/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.ClassLister;
import adams.core.Properties;
import adams.db.AbstractDatabaseConnection;
import adams.db.AbstractTable;
import adams.db.ColumnMapping;
import adams.db.SimpleResultSet;
import adams.db.indices.Index;
import adams.db.indices.IndexColumn;
import adams.db.indices.Indices;
import adams.db.types.SQL_type;
import adams.env.Environment;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;

public abstract class AbstractIndexedTable
extends AbstractTable {
    private static final long serialVersionUID = 2013793322024355971L;
    public static final String FILENAME = "Table.props";
    protected boolean m_init = false;
    protected static Properties m_Properties;

    protected AbstractIndexedTable(AbstractDatabaseConnection dbcon, String tableName) {
        super(dbcon, tableName);
        this.setDebug(AbstractIndexedTable.getProperties().getBoolean(this.getClass().getName() + ".Debug", false));
        this.debug(this.m_DatabaseConnection.toString());
    }

    protected static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("table");
        }
        return m_Properties;
    }

    protected abstract Indices getIndices();

    protected abstract ColumnMapping getColumnMapping();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean columnsMatchTest(ColumnMapping cm, boolean print, boolean tryAgain, boolean addMissing) {
        boolean ok;
        block20: {
            Connection connection = this.m_DatabaseConnection.getConnection(true);
            SimpleResultSet rs = null;
            ok = true;
            try {
                DatabaseMetaData dbmd = connection.getMetaData();
                rs = new SimpleResultSet(dbmd.getColumns(null, null, this.m_TableName, null));
                HashSet<String> columns = new HashSet<String>();
                while (rs.next()) {
                    String cname = rs.getString("COLUMN_NAME");
                    columns.add(cname);
                    int type = rs.getInt("DATA_TYPE");
                    int size = rs.getInt("COLUMN_SIZE");
                    SQL_type columnType = new SQL_type(type, size);
                    SQL_type expectedColumn = cm.getMapping(cname);
                    if (expectedColumn == null) {
                        if (print) {
                            this.getSystemErr().println("false because expectedColumn null for '" + cname + "' (" + this.getTableName() + ")");
                        }
                        ok = false;
                        continue;
                    }
                    if (expectedColumn.equivalentTo(columnType)) continue;
                    if (print) {
                        this.getSystemErr().println("false because column type different for '" + cname + "': " + expectedColumn.getCompareType() + " != " + columnType.getCompareType() + " " + this.getTableName() + ")");
                    }
                    ok = false;
                }
                if (columns.size() != cm.size()) {
                    Enumeration<String> keys = cm.keys();
                    while (keys.hasMoreElements()) {
                        String cname = keys.nextElement();
                        if (columns.contains(cname)) continue;
                        if (!addMissing) {
                            ok = false;
                            break;
                        }
                        SQL_type type = cm.getMapping(cname);
                        String sql = "ALTER TABLE " + this.getTableName() + " ADD COLUMN ";
                        sql = sql + cname + " " + type.getCreateType();
                        try {
                            this.execute(sql);
                        }
                        catch (Exception e) {
                            ok = false;
                        }
                        if (print) {
                            this.getSystemErr().println("Adding column '" + cname + "' (" + this.getTableName() + "): " + ok);
                        }
                        if (!ok) break;
                        columns.add(cname);
                    }
                    if (addMissing && columns.size() != cm.size()) {
                        if (print) {
                            this.getSystemErr().println("false because column count.columnCount=" + columns.size() + ", cmsize=" + cm.size() + " (" + this.getTableName() + ")");
                        }
                        ok = false;
                    }
                }
                AbstractIndexedTable.closeAll(rs);
            }
            catch (SQLException e) {
                if (tryAgain) {
                    AbstractIndexedTable.closeAll(rs);
                    ok = this.columnsMatchTest(cm, print, false, addMissing);
                }
            }
            catch (Exception e2) {
                AbstractIndexedTable.closeAll(rs);
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                AbstractIndexedTable.closeAll(rs);
            }
        }
        return ok;
    }

    protected boolean columnsMatch(ColumnMapping cm, boolean print, boolean addMissing) {
        return this.columnsMatchTest(cm, print, true, addMissing);
    }

    public synchronized boolean init() {
        boolean result;
        if (this.tableExists()) {
            result = this.columnsMatch(this.getColumnMapping(), true, true);
        } else {
            result = this.create();
            if (result) {
                result = this.postCreate();
            }
        }
        return result;
    }

    protected boolean create() {
        ColumnMapping cm = this.getColumnMapping();
        String sql = "CREATE TABLE " + this.m_TableName + " (";
        Enumeration<String> enum1 = cm.keys();
        while (enum1.hasMoreElements()) {
            String cname = enum1.nextElement();
            SQL_type type = cm.getMapping(cname);
            sql = sql + " " + cname + " " + type.getCreateType();
            if (enum1.hasMoreElements()) {
                sql = sql + ",";
                continue;
            }
            if (cm.hasPrimaryKey()) {
                sql = sql + ", PRIMARY KEY(" + cm.getPrimaryKey() + ")";
            }
            sql = sql + ")";
        }
        try {
            this.debug("Creating table: " + sql);
            if (this.execute(sql)) {
                return false;
            }
        }
        catch (Exception e) {
            this.getSystemErr().println("Error creating table: " + sql);
            this.getSystemErr().printStackTrace(e);
        }
        Indices ind = this.getIndices();
        if (ind != null) {
            for (int i = 0; i < ind.size(); ++i) {
                sql = "CREATE INDEX IND_" + i + " ON " + this.m_TableName + " (";
                Index index = (Index)ind.get(i);
                for (int j = 0; j < index.size() - 1; ++j) {
                    IndexColumn ic = (IndexColumn)index.get(j);
                    sql = sql + " " + ic.toString() + ",";
                }
                sql = sql + " " + ((IndexColumn)index.get(index.size() - 1)).toString() + ")";
                try {
                    this.debug("Creating indices: " + sql);
                    if (!this.execute(sql)) continue;
                    return false;
                }
                catch (Exception e) {
                    this.getSystemErr().println("Error creating indices: " + sql);
                    this.getSystemErr().printStackTrace(e);
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean postCreate() {
        return true;
    }

    public boolean isThere(String condition) {
        try {
            SimpleResultSet rs = new SimpleResultSet(this.select("*", condition));
            if (!rs.next()) {
                AbstractIndexedTable.closeAll(rs);
                return false;
            }
            AbstractIndexedTable.closeAll(rs);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int update(String updateString, String where) throws Exception {
        return this.update(updateString, this.getTableName(), where);
    }

    public boolean truncate() {
        return this.truncate(this.getTableName());
    }

    public ResultSet select(String columns) throws Exception {
        return this.doSelect(false, columns, this.getTableName(), null);
    }

    public ResultSet select(String columns, String where) throws Exception {
        return this.doSelect(false, columns, this.getTableName(), where);
    }

    public ResultSet selectDistinct(String columns) throws Exception {
        return this.doSelect(true, columns, this.getTableName(), null);
    }

    public ResultSet selectDistinct(String columns, String where) throws Exception {
        return this.doSelect(true, columns, this.getTableName(), where);
    }

    public static String[] getTables() {
        return ClassLister.getSingleton().getClassnames(AbstractIndexedTable.class);
    }

    public static synchronized void initTables(AbstractDatabaseConnection dbcon) {
        boolean debug = AbstractIndexedTable.getProperties().getBoolean("InitTables.Debug", false);
        String[] tables = AbstractIndexedTable.getTables();
        for (int i = 0; i < tables.length; ++i) {
            try {
                if (debug) {
                    System.out.println("Initializing table: " + tables[i]);
                }
                Class<?> cls = Class.forName(tables[i]);
                try {
                    Method method = cls.getMethod("initTable", AbstractDatabaseConnection.class);
                    method.invoke(null, dbcon);
                }
                catch (Exception e) {
                    System.err.println("Failed to initialize table '" + tables[i] + "'!");
                    if (!debug) continue;
                    e.printStackTrace();
                }
                continue;
            }
            catch (Exception e) {
                System.err.println("Error initializing table '" + tables[i] + "':");
                e.printStackTrace();
            }
        }
    }
}

