/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.base.BaseDateTime;
import adams.core.base.BaseRegExp;
import adams.db.AbstractLimitedConditions;

public class LogEntryConditions
extends AbstractLimitedConditions {
    private static final long serialVersionUID = 7496947748107342392L;
    protected BaseRegExp m_Host;
    protected BaseRegExp m_IP;
    protected BaseRegExp m_Type;
    protected BaseRegExp m_Status;
    protected BaseRegExp m_Source;
    protected BaseDateTime m_GenerationStartDate;
    protected BaseDateTime m_GenerationEndDate;
    protected boolean m_Latest;

    public String globalInfo() {
        return "Conditions for retrieving log entries.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", new BaseRegExp(""));
        this.m_OptionManager.add("ip", "IP", new BaseRegExp(""));
        this.m_OptionManager.add("type", "type", new BaseRegExp(""));
        this.m_OptionManager.add("status", "status", new BaseRegExp(""));
        this.m_OptionManager.add("source", "source", new BaseRegExp(""));
        this.m_OptionManager.add("generation-start", "generationStartDate", new BaseDateTime("-INF"));
        this.m_OptionManager.add("generation-end", "generationEndDate", new BaseDateTime("+INF"));
        this.m_OptionManager.add("latest", "latest", false);
    }

    public void setHost(BaseRegExp value) {
        this.m_Host = value;
        this.reset();
    }

    public BaseRegExp getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host name to use in the search (regular expression).";
    }

    public void setIP(BaseRegExp value) {
        this.m_IP = value;
        this.reset();
    }

    public BaseRegExp getIP() {
        return this.m_IP;
    }

    public String IPTipText() {
        return "The IP address to use in the search (regular expression).";
    }

    public void setType(BaseRegExp value) {
        this.m_Type = value;
        this.reset();
    }

    public BaseRegExp getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The log entry type to use in the search (regular expression).";
    }

    public void setStatus(BaseRegExp value) {
        this.m_Status = value;
        this.reset();
    }

    public BaseRegExp getStatus() {
        return this.m_Status;
    }

    public String statusTipText() {
        return "The log entry status to use in the search (regular expression).";
    }

    public void setSource(BaseRegExp value) {
        this.m_Source = value;
        this.reset();
    }

    public BaseRegExp getSource() {
        return this.m_Source;
    }

    public String sourceTipText() {
        return "The log entry type to use in the search (regular expression).";
    }

    public void setGenerationStartDate(BaseDateTime value) {
        this.m_GenerationStartDate = value;
        this.reset();
    }

    public BaseDateTime getGenerationStartDate() {
        return this.m_GenerationStartDate;
    }

    public String generationStartDateTipText() {
        return "The start date for the log entry generation.";
    }

    public void setGenerationEndDate(BaseDateTime value) {
        this.m_GenerationEndDate = value;
        this.reset();
    }

    public BaseDateTime getGenerationEndDate() {
        return this.m_GenerationEndDate;
    }

    public String generationEndDateTipText() {
        return "The end date for the log entry generation.";
    }

    public void setLatest(boolean value) {
        this.m_Latest = value;
        this.reset();
    }

    public boolean getLatest() {
        return this.m_Latest;
    }

    public String latestTipText() {
        return "Returns only the latest entries, i.e., works backwards from the generation end date.";
    }

    protected void update() {
        if (this.m_Host == null) {
            this.m_Host = new BaseRegExp("");
        }
        if (this.m_IP == null) {
            this.m_IP = new BaseRegExp("");
        }
        if (this.m_Type == null) {
            this.m_Type = new BaseRegExp("");
        }
        if (this.m_Status == null) {
            this.m_Status = new BaseRegExp("");
        }
        if (this.m_Source == null) {
            this.m_Status = new BaseRegExp("");
        }
    }
}

