/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.docbook;

import adams.doc.docbook.AbstractComplexElement;
import adams.doc.docbook.AbstractElement;
import adams.doc.docbook.Paragraph;
import adams.doc.docbook.Title;

public class Section
extends AbstractComplexElement {
    private static final long serialVersionUID = 6147436275145204642L;

    public Section() {
        super("section");
    }

    public Section(String title) {
        this();
        this.add(new Title(title));
    }

    public Section(String title, String content) {
        this(title);
        this.setContent(content);
    }

    protected void removeParagraphs(boolean onlyEmpty) {
        int i = 0;
        while (i < this.getChildCount()) {
            AbstractElement element = (AbstractElement)this.getChildAt(i);
            if (element instanceof Paragraph) {
                if (onlyEmpty && ((Paragraph)element).isEmpty()) {
                    this.remove(i);
                    continue;
                }
                if (!onlyEmpty) {
                    this.remove(i);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    public void setContent(String content) {
        String[] lines;
        this.removeParagraphs(false);
        for (String line : lines = content.split("\n")) {
            this.add(new Paragraph(line));
        }
    }

    protected void doValidate() {
        boolean valid = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.getChildAt(i) instanceof Paragraph) {
                valid = true;
                break;
            }
            if (!(this.getChildAt(i) instanceof Section)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            this.add(new Paragraph());
        }
    }
}

