/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.control.Sequence;
import adams.flow.control.SequentialDirector;
import adams.flow.core.AbstractActor;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubProcess
extends Sequence
implements OutputProducer {
    private static final long serialVersionUID = 7433940498896052594L;
    protected transient Vector<Token> m_OutputTokens;

    @Override
    public String globalInfo() {
        return "Encapsulates a sequence of flow items. The first actor must accept input and the last one must produce output.";
    }

    protected Vector<Token> getOutputTokens() {
        if (this.m_OutputTokens == null) {
            this.m_OutputTokens = new Vector();
        }
        return this.m_OutputTokens;
    }

    @Override
    protected SequentialDirector newDirector() {
        return new SubProcessDirector();
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && this.active() == 0) {
            result = "No active (= non-skipped) actors!";
        }
        if (result == null) {
            if (!(this.firstActive() instanceof InputConsumer)) {
                result = "First actor ('" + this.firstActive().getName() + "') does not accept input!";
            } else if (!(this.lastActive() instanceof OutputProducer)) {
                result = "Last actor ('" + this.lastActive().getName() + "') does not generate output!";
            }
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        if (this.active() > 0) {
            return ((InputConsumer)((Object)this.firstActive())).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        if (this.active() > 0) {
            return ((OutputProducer)((Object)this.lastActive())).generates();
        }
        return new Class[]{Unknown.class};
    }

    protected void addOutputToken(Token output) {
        this.getOutputTokens().add(output);
    }

    @Override
    public Token output() {
        Token result = this.getOutputTokens().get(0);
        this.getOutputTokens().remove(0);
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.getOutputTokens().size() > 0;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_OutputTokens != null) {
            this.m_OutputTokens.clear();
        }
    }

    public static class SubProcessDirector
    extends SequentialDirector {
        private static final long serialVersionUID = 1600945233224761728L;

        public void setControlActor(AbstractDirectedControlActor value) {
            if (value instanceof SubProcess || value == null) {
                super.setControlActor(value);
            } else {
                System.err.println("Group must be a SubProcess actor (provided: " + (value != null ? value.getClass().getName() : "-null-") + ")!");
            }
        }

        protected boolean isFinalOutputRecorded() {
            return true;
        }

        protected String doExecuteActors(AbstractActor startActor) {
            String result = super.doExecuteActors(startActor);
            if (result == null) {
                for (int i = 0; i < this.m_FinalOutput.size(); ++i) {
                    ((SubProcess)this.getControlActor()).addOutputToken((Token)this.m_FinalOutput.get(i));
                }
            }
            return result;
        }
    }
}

