/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.base.BaseString;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.control.AbstractDirector;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.sink.Null;
import adams.parser.BooleanExpression;
import adams.parser.GrammarSupplier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Switch
extends AbstractDirectedControlActor
implements InputConsumer,
MutableActorHandler,
GrammarSupplier {
    private static final long serialVersionUID = 185561131623293880L;
    public static final String BACKUP_INPUT = "input";
    protected BaseString[] m_Expressions;
    protected Vector<AbstractActor> m_Cases;
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Emulates a Switch control statement. The first 'expression' that evaluates to 'true' executes the corresponding 'case' actor and stops evaluation of expressions.\nA catch-all or default can be set up as well by having one more 'case' than 'expressions' (the last case acts as default).\nIn case of integer or double tokens that arrive at the input, these can be accessed in the expression via 'X'. Strings can be accessed via \"X\" in the expression.\n\nThe following grammar is used for evaluating the boolean expressions:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return new BooleanExpression().getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expressions", new BaseString[]{new BaseString("true")});
        this.m_OptionManager.add("case", "cases", new AbstractActor[]{new Null()});
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_InputToken = null;
        this.m_Cases = new Vector();
    }

    @Override
    protected AbstractDirector newDirector() {
        return new SwitchDirector();
    }

    public void setExpressions(BaseString[] value) {
        this.m_Expressions = value;
        this.reset();
    }

    public BaseString[] getExpressions() {
        return this.m_Expressions;
    }

    public String expressionsTipText() {
        return "The switch conditions to evaluate - the first epxression that evaluates to 'true' triggers the execution of the corresponding 'case' actor.";
    }

    public void setCases(AbstractActor[] value) {
        ActorUtils.uniqueNames(value);
        this.m_Cases.clear();
        for (int i = 0; i < value.length; ++i) {
            this.m_Cases.add(value[i]);
        }
        this.updateParent();
        this.reset();
    }

    public AbstractActor[] getCases() {
        return this.m_Cases.toArray(new AbstractActor[this.m_Cases.size()]);
    }

    public String casesTipText() {
        return "The 'cases' - one of them gets executed if the corresponding 'expression' evaluates to 'true'.";
    }

    @Override
    public String getQuickInfo() {
        String result = this.m_Expressions.length + " expression";
        if (this.m_Expressions.length != 1) {
            result = result + "s";
        }
        return result;
    }

    @Override
    public int size() {
        return this.m_Cases.size();
    }

    @Override
    public AbstractActor get(int index) {
        return this.m_Cases.get(index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index > -1 && index < this.m_Cases.size()) {
            ActorUtils.uniqueName(actor, this, index);
            this.m_Cases.set(index, actor);
            this.reset();
            this.updateParent();
        } else {
            this.getSystemErr().println("Index out of range (0-" + (this.m_Cases.size() - 1) + "): " + index);
        }
    }

    @Override
    public void add(int index, AbstractActor actor) {
        this.m_Cases.add(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Cases.remove(index);
        this.reset();
        return result;
    }

    @Override
    public void removeAll() {
        this.m_Cases.clear();
        this.reset();
    }

    @Override
    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.m_Cases.size(); ++i) {
            if (!this.m_Cases.get(i).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(false, ActorExecution.PARALLEL, true);
    }

    @Override
    public Class[] accepts() {
        HashSet<Class> result = new HashSet<Class>();
        if (this.m_Cases.size() == 0) {
            result.add(Unknown.class);
        } else {
            for (AbstractActor actor : this.m_Cases) {
                if (!(actor instanceof InputConsumer)) continue;
                result.addAll(Arrays.asList(((InputConsumer)((Object)actor)).accepts()));
            }
        }
        return result.toArray(new Class[result.size()]);
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INPUT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            ((SwitchDirector)this.m_Director).setCaseToken(this.m_InputToken);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (this.m_Expressions == null || this.m_Expressions.length == 0) {
                result = "No expression provided!";
            } else if (this.m_Cases.size() > this.m_Expressions.length + 1) {
                result = "Only 1 default case can be defined: " + this.m_Expressions + " expression(s) but " + this.m_Cases.size() + " case(s)";
            } else if (this.m_Cases.size() < this.m_Expressions.length) {
                result = "Not enough cases defined: " + this.m_Expressions.length + " required";
            }
        }
        return result;
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
        ((SwitchDirector)this.m_Director).setCaseToken(this.m_InputToken);
    }

    @Override
    public void cleanUp() {
        this.m_InputToken = null;
        super.cleanUp();
    }

    public static class SwitchDirector
    extends AbstractDirector {
        private static final long serialVersionUID = 8414511259688024553L;
        protected transient Token m_CaseToken;

        public void setControlActor(AbstractDirectedControlActor value) {
            if (value instanceof Switch || value == null) {
                super.setControlActor(value);
            } else {
                System.err.println("Group must be a Switch actor (provided: " + (value != null ? value.getClass().getName() : "-null-") + ")!");
            }
        }

        public void setCaseToken(Token value) {
            this.m_CaseToken = value;
        }

        public Token getCaseToken() {
            return this.m_CaseToken;
        }

        protected int whichCase() {
            int i;
            int result = -1;
            Switch switchActor = (Switch)this.m_ControlActor;
            HashMap<String, Double> symbols = new HashMap<String, Double>();
            boolean hasString = false;
            for (i = 0; i < switchActor.getExpressions().length; ++i) {
                if (switchActor.getExpressions()[i].getValue().indexOf("\"X\"") <= -1) continue;
                hasString = true;
                break;
            }
            if (this.m_CaseToken.getPayload() instanceof Integer) {
                symbols.put("X", ((Integer)this.m_CaseToken.getPayload()).doubleValue());
            } else if (this.m_CaseToken.getPayload() instanceof Double) {
                symbols.put("X", (Double)this.m_CaseToken.getPayload());
            }
            for (i = 0; i < switchActor.getExpressions().length; ++i) {
                String exp = this.getVariables().expand(switchActor.getExpressions()[i].getValue());
                if (this.m_CaseToken.getPayload() instanceof String && hasString) {
                    exp = exp.replace("\"X\"", "\"" + this.m_CaseToken.getPayload() + "\"");
                }
                try {
                    if (!BooleanExpression.evaluate(exp, symbols)) continue;
                    result = i;
                    break;
                }
                catch (Exception e) {
                    this.getSystemErr().println("Error evaluating boolean expression: " + exp);
                    this.getSystemErr().printStackTrace(e);
                }
            }
            if (result == -1 && switchActor.getCases().length > switchActor.getExpressions().length) {
                result = switchActor.getCases().length - 1;
            }
            return result;
        }

        public String execute() {
            String result = null;
            int index = this.whichCase();
            if (index == -1) {
                result = "No matching case found!";
            } else {
                AbstractActor caseActor = ((Switch)this.m_ControlActor).get(index);
                try {
                    if (caseActor instanceof InputConsumer) {
                        ((InputConsumer)((Object)caseActor)).input(this.m_CaseToken);
                    }
                    result = caseActor.execute();
                }
                catch (Exception e) {
                    String msg = caseActor.getFullName() + " generated the following exception: ";
                    result = msg + e;
                    this.getSystemErr().println(msg);
                    this.getSystemErr().printStackTrace(e);
                }
                if (result != null) {
                    caseActor.handleError("execute", result);
                }
            }
            return result;
        }

        public void cleanUp() {
            this.m_CaseToken = null;
            super.cleanUp();
        }
    }
}

