/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractControlActor;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.parser.BooleanExpression;
import adams.parser.GrammarSupplier;
import java.util.HashMap;

public class WhileLoop
extends AbstractControlActor
implements InputConsumer,
GrammarSupplier,
MutableActorHandler {
    private static final long serialVersionUID = -2837014912083918343L;
    protected String m_Expression;
    protected Sequence m_Actors;

    public String globalInfo() {
        return "Emulates a while-loop. The sub-actor gets executed as long as the expression evaluates to 'true'.\n\nThe following grammar is used for evaluating the boolean expressions:\n\n" + this.getGrammar();
    }

    public String getGrammar() {
        return new BooleanExpression().getGrammar();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", "true");
        this.m_OptionManager.add("loop", "actors", new AbstractActor[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new Sequence();
    }

    public void setExpression(String value) {
        this.m_Expression = value;
        this.reset();
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The expression to evaluate - only as long as it evaluates to 'true' the loop actors get executed.";
    }

    public void setActors(AbstractActor[] value) {
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors to execute in the loop.";
    }

    protected void updateParent() {
        this.m_Actors.setName(this.getName());
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(this.getParent());
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("expression");
        if (variable != null) {
            return variable;
        }
        if (this.m_Expression != null && this.m_Expression.length() > 0) {
            return this.m_Expression;
        }
        return null;
    }

    public int size() {
        return this.m_Actors.size();
    }

    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    public void set(int index, AbstractActor actor) {
        this.m_Actors.set(index, actor);
        this.reset();
        this.updateParent();
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public void add(int index, AbstractActor actor) {
        this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
    }

    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    protected String setUpLoopActors() {
        return null;
    }

    protected String setUpSubActors() {
        String result = null;
        if (this.m_Actors.size() == 0) {
            result = "No loop-actors provided!";
        }
        if (result == null && !this.getSkip()) {
            this.updateParent();
            result = this.setUpLoopActors();
            if (result == null) {
                result = this.m_Actors.setUp();
            }
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && (this.m_Expression == null || this.m_Expression.length() == 0)) {
            result = "No expression provided!";
        }
        return result;
    }

    public void input(Token token) {
    }

    protected boolean doLoop() {
        boolean result;
        String exp = this.getVariables().expand(this.m_Expression);
        HashMap symbols = new HashMap();
        try {
            result = BooleanExpression.evaluate(exp, symbols);
        }
        catch (Exception e) {
            this.getSystemErr().println("Error evaluating boolean expression: " + exp);
            this.getSystemErr().printStackTrace(e);
            result = false;
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        while (this.doLoop() && result == null && !this.isStopped()) {
            try {
                result = this.m_Actors.execute();
            }
            catch (Exception e) {
                String msg = this.m_Actors.getFullName() + " generated following exception: ";
                result = msg + e;
                this.getSystemErr().println(msg);
                this.getSystemErr().printStackTrace(e);
            }
        }
        if (result != null) {
            this.m_Actors.handleError("execute", result);
        }
        return result;
    }

    public void pauseExecution() {
        this.m_Actors.pauseExecution();
    }

    public boolean isPaused() {
        return this.m_Actors.isPaused();
    }

    public void resumeExecution() {
        this.m_Actors.resumeExecution();
    }

    public void stopExecution() {
        this.m_Actors.stopExecution();
        super.stopExecution();
    }
}

