/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.provenance;

import adams.core.CloneHandler;
import adams.core.option.MaterializedArrayProducer;
import adams.flow.core.AbstractActor;
import adams.flow.provenance.ActorType;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvenanceInformation
implements Serializable,
CloneHandler<ProvenanceInformation> {
    private static final long serialVersionUID = -8879950520072626172L;
    protected ActorType m_ActorType;
    protected Class m_InputDataType;
    protected Class m_OutputDataType;
    protected String[] m_Options;

    public ProvenanceInformation(ActorType actorType, AbstractActor actor) {
        this(actorType, ProvenanceInformation.toOptions(actor));
    }

    public ProvenanceInformation(ActorType actorType, String[] options) {
        this(actorType, null, options, null);
    }

    public ProvenanceInformation(ActorType actorType, Class input, AbstractActor actor) {
        this(actorType, input, ProvenanceInformation.toOptions(actor));
    }

    public ProvenanceInformation(ActorType actorType, Class input, String[] options) {
        this(actorType, input, options, null);
    }

    public ProvenanceInformation(ActorType actorType, AbstractActor actor, Class output) {
        this(actorType, ProvenanceInformation.toOptions(actor), output);
    }

    public ProvenanceInformation(ActorType actorType, String[] options, Class output) {
        this(actorType, null, options, output);
    }

    public ProvenanceInformation(ActorType actorType, Class input, AbstractActor actor, Class output) {
        this(actorType, input, ProvenanceInformation.toOptions(actor), output);
    }

    public ProvenanceInformation(ActorType actorType, Class input, String[] options, Class output) {
        this.m_ActorType = actorType;
        this.m_InputDataType = input;
        this.m_OutputDataType = output;
        this.m_Options = (String[])options.clone();
    }

    public ActorType getActorType() {
        return this.m_ActorType;
    }

    public boolean hasInputDataType() {
        return this.m_InputDataType != null;
    }

    public Class getInputDataType() {
        return this.m_InputDataType;
    }

    public boolean hasOutputDataType() {
        return this.m_OutputDataType != null;
    }

    public Class getOutputDataType() {
        return this.m_OutputDataType;
    }

    public String[] getOptions() {
        return this.m_Options;
    }

    public String getClassname() {
        return this.m_Options[0];
    }

    @Override
    public ProvenanceInformation getClone() {
        return new ProvenanceInformation(this.m_ActorType, this.m_InputDataType, this.m_Options, this.m_OutputDataType);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("actorType=" + (Object)((Object)this.m_ActorType));
        if (this.hasInputDataType()) {
            result.append(", input=" + this.m_InputDataType);
        }
        result.append(", actor=" + this.m_Options[0]);
        if (this.hasOutputDataType()) {
            result.append(", output=" + this.m_OutputDataType);
        }
        return result.toString();
    }

    protected static String[] toOptions(AbstractActor actor) {
        MaterializedArrayProducer producer = new MaterializedArrayProducer();
        producer.produce(actor);
        return producer.getOutput();
    }
}

