/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.VariableName;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.core.InputConsumer;
import adams.flow.sink.AbstractGraphicsGenerator;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.ImageViewer;
import adams.gui.print.NullWriter;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Screenshot
extends AbstractGraphicsGenerator {
    private static final long serialVersionUID = 4613925594824175758L;
    public static final String BACKUP_COUNTER = "counter";
    protected DisplayPanelProvider m_PanelProvider;
    protected String m_FilenamePrefix;
    protected VariableName m_FilenameVariable;
    protected int m_Counter;

    @Override
    public String globalInfo() {
        return "Actor that takes screenshots of graphical components.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("provider", "panelProvider", new ImageViewer());
        this.m_OptionManager.add("filename-prefix", "filenamePrefix", "screenshot");
        this.m_OptionManager.add("filename-var", "filenameVariable", new VariableName());
    }

    @Override
    public String getQuickInfo() {
        String result;
        String variable = this.getOptionManager().getVariableForProperty("filenameVariable");
        if (variable != null) {
            result = variable;
        } else if (this.m_FilenameVariable != null && this.m_FilenameVariable.getValue().length() > 0) {
            result = "@{" + this.m_FilenameVariable + "}";
        } else {
            variable = this.getOptionManager().getVariableForProperty("output");
            String output = variable == null ? this.m_Output.toString() : variable;
            variable = this.getOptionManager().getVariableForProperty("filenamePrefix");
            String prefix = variable == null ? this.m_FilenamePrefix.toString() : variable;
            if (!(this.getWriter() instanceof NullWriter)) {
                result = output + File.separator + prefix + "XYZ";
                if (this.getWriter().getExtensions().length > 0) {
                    result = result + this.getWriter().getExtensions()[0];
                }
            } else {
                result = output;
            }
        }
        return result;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_COUNTER);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_COUNTER, this.m_Counter);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_COUNTER)) {
            this.m_Counter = (Integer)state.get(BACKUP_COUNTER);
            state.remove(BACKUP_COUNTER);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Counter = 0;
    }

    @Override
    protected String getDefaultTitle() {
        return "Screenshot";
    }

    @Override
    protected int getDefaultWidth() {
        return 800;
    }

    @Override
    protected int getDefaultHeight() {
        return 600;
    }

    @Override
    public String outputTipText() {
        return "The output directory.";
    }

    public void setPanelProvider(DisplayPanelProvider value) {
        this.m_PanelProvider = value;
        this.reset();
    }

    public DisplayPanelProvider getPanelProvider() {
        return this.m_PanelProvider;
    }

    public String panelProviderTipText() {
        return "The actor for generating the display panels to take a screenshot of.";
    }

    public void setFilenamePrefix(String value) {
        this.m_FilenamePrefix = value;
        this.reset();
    }

    public String getFilenamePrefix() {
        return this.m_FilenamePrefix;
    }

    public String filenamePrefixTipText() {
        return "The prefix for the filename in case of auto-generation (no path, just name).";
    }

    public void setFilenameVariable(VariableName value) {
        this.m_FilenameVariable = value;
        this.reset();
    }

    public VariableName getFilenameVariable() {
        return this.m_FilenameVariable;
    }

    public String filenameVariableTipText() {
        return "The variable to use for the filename instead of the auto-generated one.";
    }

    @Override
    public Class[] accepts() {
        if (this.m_PanelProvider != null && this.m_PanelProvider instanceof InputConsumer) {
            return ((InputConsumer)((Object)this.m_PanelProvider)).accepts();
        }
        return new Class[]{Object.class};
    }

    @Override
    protected JComponent generateComponent() {
        return this.m_PanelProvider.createDisplayPanel(this.m_InputToken);
    }

    @Override
    protected PlaceholderFile generateFilename() {
        ++this.m_Counter;
        PlaceholderFile result = this.getVariables().has(this.m_FilenameVariable.getValue()) ? new PlaceholderFile(this.getVariables().get(this.m_FilenameVariable.getValue())) : new PlaceholderFile(this.m_Output.getAbsolutePath() + File.separator + FileUtils.createFilename(this.m_FilenamePrefix + this.m_Counter + this.m_Writer.getExtensions()[0], "_"));
        return result;
    }
}

