/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.InteractiveActor;
import adams.flow.source.AbstractSource;

public abstract class AbstractInteractiveSource
extends AbstractSource
implements InteractiveActor {
    private static final long serialVersionUID = 9035095174755816475L;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", "");
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public abstract boolean doInteract();

    protected String doExecute() {
        if (!this.isHeadless() && !this.doInteract() && this.m_StopFlowIfCanceled) {
            if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                this.stopExecution("Flow canceled: " + this.getFullName());
            } else {
                this.stopExecution(this.m_CustomStopMessage);
            }
        }
        return this.m_StopMessage;
    }
}

