/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.DatabaseConnection;
import adams.tools.AbstractTool;
import adams.tools.InitializeTables;

public class Tool
extends AbstractStandalone {
    private static final long serialVersionUID = -295054877801672294L;
    protected AbstractTool m_Tool;

    public String globalInfo() {
        return "Runs a tool.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tool", "tool", new InitializeTables());
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("tool");
        if (variable != null) {
            return variable;
        }
        return this.m_Tool.getClass().getName().replaceAll(".*\\.tools\\.", "");
    }

    public void setTool(AbstractTool value) {
        this.m_Tool = value;
        this.reset();
    }

    public AbstractTool getTool() {
        return this.m_Tool;
    }

    public String toolTipText() {
        return "The tool to run.";
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return adams.db.DatabaseConnection.getSingleton();
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection(this, DatabaseConnection.class, this.getDefaultDatabaseConnection());
    }

    protected String doExecute() {
        String result;
        try {
            if (this.m_Tool instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)((Object)this.m_Tool)).setDatabaseConnection(this.getDatabaseConnection());
            }
            this.m_Tool.run();
            result = null;
        }
        catch (Exception e) {
            result = e.toString();
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }
}

