/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.report.Report;
import adams.db.AbstractDatabaseConnection;
import adams.db.ReportProvider;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportDbReader<T extends Report>
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 7352720726300796621L;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection();
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    @Override
    public Class[] accepts() {
        return new Class[]{Integer.class};
    }

    @Override
    public abstract Class[] generates();

    protected abstract ReportProvider<T> getReportProvider();

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        int id = (Integer)this.m_InputToken.getPayload();
        ReportProvider<T> provider = this.getReportProvider();
        T report = provider.load(id);
        if (report == null) {
            result = "No report loaded for ID: " + this.m_InputToken;
        } else {
            this.m_OutputToken = new Token(report);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance(this.m_OutputToken);
        }
        return result;
    }

    @Override
    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this, this.m_OutputToken.getPayload().getClass()));
        }
    }

    @Override
    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }
}

