/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.control.StorageName;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class IncStorageValue
extends AbstractTransformer {
    private static final long serialVersionUID = 4563837784851442207L;
    protected StorageName m_StorageName;
    protected IncrementType m_IncrementType;
    protected int m_IntegerIncrement;
    protected double m_DoubleIncrement;

    public String globalInfo() {
        return "Increments the value of a storage value by either an integer or double increment.\nIf the storage value has not been set yet, it will get set to 0.\nIf the storage value contains a non-numerical value, no increment will be performed.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName());
        this.m_OptionManager.add("inc-type", "incrementType", (Object)IncrementType.INTEGER);
        this.m_OptionManager.add("inc-int", "integerIncrement", 1);
        this.m_OptionManager.add("inc-double", "doubleIncrement", 1.0);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("storageName");
        String result = variable != null ? variable : this.m_StorageName.getValue();
        result = result + ", " + this.m_IncrementType.toString();
        result = result + ", inc: ";
        switch (this.m_IncrementType) {
            case INTEGER: {
                variable = this.getOptionManager().getVariableForProperty("integerIncrement");
                if (variable != null) {
                    result = result + variable;
                    break;
                }
                result = result + this.m_IntegerIncrement;
                break;
            }
            case DOUBLE: {
                variable = this.getOptionManager().getVariableForProperty("doubleIncrement");
                if (variable != null) {
                    result = result + variable;
                    break;
                }
                result = result + this.m_DoubleIncrement;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled increment type: " + (Object)((Object)this.m_IncrementType));
            }
        }
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage value to increment.";
    }

    public void setIncrementType(IncrementType value) {
        this.m_IncrementType = value;
        this.reset();
    }

    public IncrementType getIncrementType() {
        return this.m_IncrementType;
    }

    public String incrementTypeTipText() {
        return "The type of increment to perform.";
    }

    public void setIntegerIncrement(int value) {
        this.m_IntegerIncrement = value;
        this.reset();
    }

    public int getIntegerIncrement() {
        return this.m_IntegerIncrement;
    }

    public String integerIncrementTipText() {
        return "The increment in case of " + (Object)((Object)IncrementType.INTEGER) + " increments.";
    }

    public void setDoubleIncrement(double value) {
        this.m_DoubleIncrement = value;
        this.reset();
    }

    public double getDoubleIncrement() {
        return this.m_DoubleIncrement;
    }

    public String doubleIncrementTipText() {
        return "The increment in case of " + (Object)((Object)IncrementType.DOUBLE) + " increments.";
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    protected String doExecute() {
        Number value;
        String result;
        block17: {
            result = null;
            try {
                if (this.getStorageHandler().getStorage().has(this.m_StorageName)) {
                    switch (this.m_IncrementType) {
                        case INTEGER: {
                            value = (Integer)this.getStorageHandler().getStorage().get(this.m_StorageName);
                            break block17;
                        }
                        case DOUBLE: {
                            value = (Double)this.getStorageHandler().getStorage().get(this.m_StorageName);
                            break block17;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled increment type: " + (Object)((Object)this.m_IncrementType));
                        }
                    }
                }
                switch (this.m_IncrementType) {
                    case INTEGER: {
                        value = new Integer(0);
                        break;
                    }
                    case DOUBLE: {
                        value = new Double(0.0);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled increment type: " + (Object)((Object)this.m_IncrementType));
                    }
                }
            }
            catch (Exception e) {
                value = null;
            }
        }
        if (value != null) {
            switch (this.m_IncrementType) {
                case INTEGER: {
                    value = new Integer(value.intValue() + this.m_IntegerIncrement);
                    break;
                }
                case DOUBLE: {
                    value = new Double(value.doubleValue() + this.m_DoubleIncrement);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled increment type: " + (Object)((Object)this.m_IncrementType));
                }
            }
            this.getStorageHandler().getStorage().put(this.m_StorageName, value);
            if (this.isDebugOn()) {
                this.debug("Incremented storage '" + this.m_StorageName + "': " + value);
            }
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncrementType {
        INTEGER,
        DOUBLE;

    }
}

