/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import adams.gui.core.BasePanel;

public abstract class BasePanelWithDatabaseConnection
extends BasePanel
implements DatabaseConnectionHandler,
DatabaseConnectionChangeListener {
    private static final long serialVersionUID = 399941129570919254L;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection();
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DatabaseConnection.removeChangeListener(this);
        this.m_DatabaseConnection = value;
        this.m_DatabaseConnection.addChangeListener(this);
    }

    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
        if (e.getType() == DatabaseConnectionChangeEvent.Type.CONNECT) {
            this.setDatabaseConnection(e.getDatabaseConnection());
        }
    }
}

