/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.gui.goe.AbstractIntegralNumberEditor;
import javax.swing.SpinnerNumberModel;

public class ShortEditor
extends AbstractIntegralNumberEditor {
    public ShortEditor() {
        this.m_CurrentValue = new Short("0");
    }

    public void setValue(Object value) {
        this.m_CurrentValue = new Short(((Number)value).shortValue());
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.m_CurrentValue;
    }

    protected Object parse(String text) throws IllegalArgumentException {
        Short result;
        try {
            if (text.length() == 0) {
                text = "0";
            }
            result = new Short(text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    protected void updateBounds(SpinnerNumberModel model) {
        if (this.m_LowerBound == null) {
            model.setMinimum(new Short(Short.MIN_VALUE));
        } else {
            model.setMinimum(Integer.valueOf(this.m_LowerBound.intValue()));
        }
        if (this.m_UpperBound == null) {
            model.setMaximum(new Short(Short.MAX_VALUE));
        } else {
            model.setMaximum(Integer.valueOf(this.m_UpperBound.intValue()));
        }
    }
}

