/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.db.LogEntry;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.CustomSearchTableModel;
import adams.gui.core.SearchParameters;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogEntryViewerTableModel
extends AbstractBaseTableModel
implements CustomSearchTableModel {
    private static final long serialVersionUID = -7031190404664584447L;
    protected Vector<LogEntry> m_Data;

    public LogEntryViewerTableModel() {
        this(new Vector<LogEntry>());
    }

    public LogEntryViewerTableModel(Vector<LogEntry> data) {
        this.m_Data = new Vector<LogEntry>(data);
    }

    public Vector<LogEntry> getData() {
        return this.m_Data;
    }

    @Override
    public int getRowCount() {
        if (this.m_Data == null) {
            return 0;
        }
        return this.m_Data.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Host";
        }
        if (column == 1) {
            return "IP";
        }
        if (column == 2) {
            return "DB-ID";
        }
        if (column == 3) {
            return "Generation";
        }
        if (column == 4) {
            return "Type";
        }
        if (column == 5) {
            return "Status";
        }
        if (column == 6) {
            return "Source";
        }
        throw new IllegalArgumentException("Illegal column index: " + column);
    }

    public LogEntry getLogEntryAt(int row) {
        return this.m_Data.get(row);
    }

    @Override
    public Object getValueAt(int row, int column) {
        LogEntry entry = this.m_Data.get(row);
        if (column == 0) {
            return entry.getHost();
        }
        if (column == 1) {
            return entry.getIP();
        }
        if (column == 2) {
            return entry.getDatabaseID();
        }
        if (column == 3) {
            return entry.getGenerationAsString();
        }
        if (column == 4) {
            return entry.getType();
        }
        if (column == 5) {
            return entry.getStatus();
        }
        if (column == 6) {
            return entry.getSource();
        }
        throw new IllegalArgumentException("Illegal column index: " + column);
    }

    public Class getColumnClass(int column) {
        if (column == 2) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public boolean isSearchMatch(SearchParameters params, int row) {
        LogEntry entry = this.m_Data.get(row);
        String[] values = new String[]{entry.getHost(), entry.getIP(), entry.getGenerationAsString(), entry.getType(), entry.getStatus(), entry.getSource()};
        if (params.isInteger() && params.matches(entry.getDatabaseID())) {
            return true;
        }
        for (String value : values) {
            if (!params.matches(value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Vector<LogEntry> vector = this.m_Data;
        synchronized (vector) {
            this.m_Data.clear();
        }
        this.fireTableDataChanged();
    }

    public void add(LogEntry entry) {
        this.add(entry, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LogEntry entry, boolean sort) {
        Vector<LogEntry> vector = this.m_Data;
        synchronized (vector) {
            this.m_Data.add(entry);
        }
        if (sort) {
            Collections.sort(this.m_Data);
        }
        this.fireTableDataChanged();
    }

    public void addAll(Collection<LogEntry> entries) {
        this.addAll(entries, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<LogEntry> entries, boolean sort) {
        Vector<LogEntry> vector = this.m_Data;
        synchronized (vector) {
            this.m_Data.addAll(entries);
            if (sort) {
                Collections.sort(this.m_Data);
            }
        }
        this.fireTableDataChanged();
    }
}

