/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.axis.AbstractAxisModel;

public class LogPercentageAxisModel
extends AbstractAxisModel {
    private static final long serialVersionUID = 4789707129254053023L;

    public boolean canHandle(double min, double max) {
        return min > 0.0 && max > 0.0;
    }

    public String getDisplayName() {
        return "Log percent";
    }

    public String valueToDisplay(double value) {
        String result;
        if (Double.isNaN(value)) {
            result = this.getActualFormatter().format(value);
        } else {
            double raw = (value - this.m_Minimum) / (this.m_Maximum - this.m_Minimum) * 100.0;
            result = this.getActualFormatter().format(Math.log(raw));
        }
        return result;
    }

    public double displayToValue(String display) {
        Double result = this.getActualFormatter().parse(display);
        if (!result.isNaN()) {
            result = Math.exp(result);
            result = result / 100.0;
            result = result * (this.m_Maximum - this.m_Minimum);
            result = result + this.m_Minimum;
        }
        return result;
    }

    public int valueToPos(double value) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        double tmp = Math.log(value) - Math.log(this.m_ActualMinimum);
        tmp /= Math.log(this.m_ActualMaximum) - Math.log(this.m_ActualMinimum);
        int result = (int)Math.round(tmp *= (double)size);
        return result;
    }

    public double posToValue(int pos) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        double tmp = (double)pos / (double)size;
        tmp *= Math.log(this.m_ActualMaximum) - Math.log(this.m_ActualMinimum);
        tmp += Math.log(this.m_ActualMinimum);
        double result = tmp = Math.exp(tmp);
        return result;
    }
}

