/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.plot;

import adams.gui.core.BasePanel;
import adams.gui.core.MouseUtils;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.axis.Tick;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.AbstractHitDetector;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContentPanel
extends BasePanel
implements ChangeListener {
    protected PlotPanel m_Owner;
    protected ContentPanel m_Self;
    private static final long serialVersionUID = 1785560399953428177L;
    protected DecimalFormat m_Format;
    protected boolean m_ZoomingEnabled;
    protected Color m_ZoomBoxColor;
    protected boolean m_Zooming;
    protected boolean m_Dragged;
    protected Point m_ZoomTopLeft;
    protected Point m_ZoomBottomRight;
    protected PopupMenuCustomizer m_PopupMenuCustomizer;
    protected boolean m_PanningEnabled;
    protected boolean m_Panning;
    protected Point m_PanningStart;
    protected int m_LeftPixelOffset;
    protected int m_RightPixelOffset;
    protected int m_TopPixelOffset;
    protected int m_BottomPixelOffset;
    protected TipTextCustomizer m_TipTextCustomizer;
    protected HashSet<AbstractHitDetector> m_HitDetectors;

    public ContentPanel(PlotPanel owner) {
        this.m_Owner = owner;
    }

    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_Format = new DecimalFormat("0.0E0;-0.0E0");
        this.m_Zooming = false;
        this.m_Dragged = false;
        this.m_ZoomBoxColor = Color.GRAY;
        this.m_PopupMenuCustomizer = null;
        this.m_Panning = false;
        this.m_TipTextCustomizer = null;
        this.m_HitDetectors = new HashSet();
        this.m_ZoomingEnabled = true;
        this.m_PanningEnabled = true;
    }

    protected void initGUI() {
        this.setToolTipText("");
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (e.getButton() == 1) {
                    if (!e.isShiftDown()) {
                        if (ContentPanel.this.m_ZoomingEnabled) {
                            ContentPanel.this.m_Zooming = true;
                            ContentPanel.this.m_Dragged = false;
                            ContentPanel.this.m_ZoomTopLeft = e.getPoint();
                        }
                    } else if (e.isShiftDown() && ContentPanel.this.m_PanningEnabled) {
                        ContentPanel.this.m_Panning = true;
                        ContentPanel.this.m_PanningStart = e.getPoint();
                        ContentPanel.this.m_LeftPixelOffset = ContentPanel.this.getOwner().getAxis(Axis.LEFT).getPixelOffset();
                        ContentPanel.this.m_RightPixelOffset = ContentPanel.this.getOwner().getAxis(Axis.RIGHT).getPixelOffset();
                        ContentPanel.this.m_TopPixelOffset = ContentPanel.this.getOwner().getAxis(Axis.TOP).getPixelOffset();
                        ContentPanel.this.m_BottomPixelOffset = ContentPanel.this.getOwner().getAxis(Axis.TOP).getPixelOffset();
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (e.getButton() == 1) {
                    if (ContentPanel.this.m_Zooming && ContentPanel.this.m_Dragged) {
                        ContentPanel.this.m_Zooming = false;
                        ContentPanel.this.m_Dragged = false;
                        ContentPanel.this.m_ZoomBottomRight = e.getPoint();
                        ContentPanel.this.addZoom((int)ContentPanel.this.m_ZoomTopLeft.getY(), (int)ContentPanel.this.m_ZoomTopLeft.getX(), (int)ContentPanel.this.m_ZoomBottomRight.getY(), (int)ContentPanel.this.m_ZoomBottomRight.getX());
                    } else if (ContentPanel.this.m_Panning) {
                        ContentPanel.this.m_Panning = false;
                        int deltaX = e.getX() - (int)ContentPanel.this.m_PanningStart.getX();
                        int deltaY = (int)ContentPanel.this.m_PanningStart.getY() - e.getY();
                        ContentPanel.this.getOwner().getAxis(Axis.LEFT).setPixelOffset(ContentPanel.this.m_LeftPixelOffset + deltaY);
                        ContentPanel.this.getOwner().getAxis(Axis.RIGHT).setPixelOffset(ContentPanel.this.m_RightPixelOffset + deltaY);
                        ContentPanel.this.getOwner().getAxis(Axis.TOP).setPixelOffset(ContentPanel.this.m_TopPixelOffset + deltaX);
                        ContentPanel.this.getOwner().getAxis(Axis.BOTTOM).setPixelOffset(ContentPanel.this.m_BottomPixelOffset + deltaX);
                        ContentPanel.this.repaint();
                    }
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (!MouseUtils.isPrintScreenClick(e)) {
                    if (MouseUtils.isRightClick(e)) {
                        JPopupMenu menu = ContentPanel.this.getPopupMenu(e);
                        if (menu != null) {
                            menu.show(ContentPanel.this.m_Self, e.getX(), e.getY());
                        }
                    } else if (e.getButton() == 1 && e.getClickCount() == 1) {
                        ContentPanel.this.detectHits(e);
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                if (ContentPanel.this.m_Zooming && !e.isShiftDown()) {
                    ContentPanel.this.m_Dragged = true;
                    ContentPanel.this.m_ZoomBottomRight = e.getPoint();
                    ContentPanel.this.repaint();
                } else if (ContentPanel.this.m_Panning && e.isShiftDown()) {
                    int deltaX = e.getX() - (int)ContentPanel.this.m_PanningStart.getX();
                    int deltaY = (int)ContentPanel.this.m_PanningStart.getY() - e.getY();
                    ContentPanel.this.getOwner().getAxis(Axis.LEFT).setPixelOffset(ContentPanel.this.m_LeftPixelOffset + deltaY);
                    ContentPanel.this.getOwner().getAxis(Axis.RIGHT).setPixelOffset(ContentPanel.this.m_RightPixelOffset + deltaY);
                    ContentPanel.this.getOwner().getAxis(Axis.TOP).setPixelOffset(ContentPanel.this.m_TopPixelOffset + deltaX);
                    ContentPanel.this.getOwner().getAxis(Axis.BOTTOM).setPixelOffset(ContentPanel.this.m_BottomPixelOffset + deltaX);
                    ContentPanel.this.repaint();
                }
            }
        });
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ContentPanel.this.requestFocusInWindow();
                super.mouseClicked(e);
            }
        });
    }

    public PlotPanel getOwner() {
        return this.m_Owner;
    }

    public void setZoomingEnabled(boolean value) {
        this.m_ZoomingEnabled = value;
        if (!this.m_ZoomingEnabled) {
            this.clearZoom();
        }
    }

    public boolean isZoomingEnabled() {
        return this.m_ZoomingEnabled;
    }

    public void popZoom() {
        if (this.getOwner().isZoomed()) {
            this.getOwner().getAxis(Axis.TOP).popZoom();
            this.getOwner().getAxis(Axis.LEFT).popZoom();
            this.getOwner().getAxis(Axis.BOTTOM).popZoom();
            this.getOwner().getAxis(Axis.RIGHT).popZoom();
        }
    }

    public void clearZoom() {
        this.getOwner().getAxis(Axis.TOP).clearZoom();
        this.getOwner().getAxis(Axis.LEFT).clearZoom();
        this.getOwner().getAxis(Axis.BOTTOM).clearZoom();
        this.getOwner().getAxis(Axis.RIGHT).clearZoom();
    }

    public void setPanningEnabled(boolean value) {
        this.m_PanningEnabled = value;
        if (!this.m_PanningEnabled) {
            this.clearPanning();
        }
    }

    public boolean isPanningEnabled() {
        return this.m_PanningEnabled;
    }

    public void clearPanning() {
        this.getOwner().getAxis(Axis.TOP).clearPanning();
        this.getOwner().getAxis(Axis.LEFT).clearPanning();
        this.getOwner().getAxis(Axis.BOTTOM).clearPanning();
        this.getOwner().getAxis(Axis.RIGHT).clearPanning();
    }

    protected int[] order(int value1, int value2) {
        int[] result = value1 < value2 ? new int[]{value1, value2} : new int[]{value2, value1};
        return result;
    }

    protected double[] order(double value1, double value2) {
        double[] result = value1 < value2 ? new double[]{value1, value2} : new double[]{value2, value1};
        return result;
    }

    public void addZoom(double top, double left, double bottom, double right) {
        double[] y = this.order(top, bottom);
        double[] x = this.order(left, right);
        this.getOwner().getAxis(Axis.LEFT).pushZoom(y[0], y[1]);
        this.getOwner().getAxis(Axis.RIGHT).pushZoom(y[0], y[1]);
        this.getOwner().getAxis(Axis.TOP).pushZoom(x[0], x[1]);
        this.getOwner().getAxis(Axis.BOTTOM).pushZoom(x[0], x[1]);
        this.repaint();
    }

    public void addZoom(int top, int left, int bottom, int right) {
        int[] y = this.order(top, bottom);
        int[] x = this.order(left, right);
        this.getOwner().getAxis(Axis.LEFT).pushZoom(this.getOwner().getAxis(Axis.LEFT).posToValue(y[1]), this.getOwner().getAxis(Axis.LEFT).posToValue(y[0]));
        this.getOwner().getAxis(Axis.RIGHT).pushZoom(this.getOwner().getAxis(Axis.RIGHT).posToValue(y[1]), this.getOwner().getAxis(Axis.RIGHT).posToValue(y[0]));
        this.getOwner().getAxis(Axis.TOP).pushZoom(this.getOwner().getAxis(Axis.TOP).posToValue(x[0]), this.getOwner().getAxis(Axis.TOP).posToValue(x[1]));
        this.getOwner().getAxis(Axis.BOTTOM).pushZoom(this.getOwner().getAxis(Axis.BOTTOM).posToValue(x[0]), this.getOwner().getAxis(Axis.BOTTOM).posToValue(x[1]));
        this.repaint();
    }

    public void setZoomBoxColor(Color value) {
        this.m_ZoomBoxColor = value;
        if (this.m_Zooming) {
            this.repaint();
        }
    }

    public Color getZoomBoxColor() {
        return this.m_ZoomBoxColor;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_PopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this.m_PopupMenuCustomizer;
    }

    public JPopupMenu getPopupMenu(MouseEvent e) {
        JMenuItem item;
        JPopupMenu result = null;
        if (this.m_ZoomingEnabled) {
            if (result == null) {
                result = new JPopupMenu();
            }
            item = new JMenuItem("Zoom out");
            item.setEnabled(this.getOwner().isZoomed());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentPanel.this.popZoom();
                    ContentPanel.this.repaint();
                }
            });
            result.add(item);
            item = new JMenuItem("Clear zoom");
            item.setEnabled(this.getOwner().isZoomed());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentPanel.this.clearZoom();
                    ContentPanel.this.repaint();
                }
            });
            result.add(item);
        }
        if (this.m_PanningEnabled) {
            if (result == null) {
                result = new JPopupMenu();
            }
            item = new JMenuItem("Undo panning");
            item.setEnabled(this.getOwner().isPanned());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentPanel.this.clearPanning();
                    ContentPanel.this.repaint();
                }
            });
            result.add(item);
        }
        if (this.m_PopupMenuCustomizer != null) {
            this.m_PopupMenuCustomizer.customizePopupMenu(e, result);
        }
        return result;
    }

    protected void clearBackground(Graphics g) {
        g.setColor(this.getOwner().getBackgroundColor());
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    protected void paintCoordindatesGrid(Graphics g) {
        g.setColor(this.getOwner().getGridColor());
        for (Axis axis : Axis.values()) {
            if (!this.getOwner().getAxis(axis).getShowGridLines() || this.getOwner().getAxisVisibility(axis) == Visibility.INVISIBLE) continue;
            AxisPanel panel = this.getOwner().getAxis(axis);
            Vector<Tick> ticks = panel.getAxisModel().getTicks();
            boolean vertical = axis == Axis.LEFT || axis == Axis.RIGHT;
            for (int i = 0; i < ticks.size(); ++i) {
                Tick tick = ticks.get(i);
                if (tick.isMinor() && panel.getShowOnlyMajorGridLines()) continue;
                int pos = panel.correctPosition(tick.getPosition());
                if (vertical) {
                    g.drawLine(0, pos, this.getWidth(), pos);
                    continue;
                }
                g.drawLine(pos, 0, pos, this.getHeight());
            }
        }
    }

    protected void paintZoomBox(Graphics g) {
        if (this.m_Zooming && this.m_Dragged) {
            int tmp;
            g.setColor(this.m_ZoomBoxColor);
            int topX = (int)this.m_ZoomTopLeft.getX();
            int topY = (int)this.m_ZoomTopLeft.getY();
            int bottomX = (int)this.m_ZoomBottomRight.getX();
            int bottomY = (int)this.m_ZoomBottomRight.getY();
            if (topX > bottomX) {
                tmp = topX;
                topX = bottomX;
                bottomX = tmp;
            }
            if (topY > bottomY) {
                tmp = topY;
                topY = bottomY;
                bottomY = tmp;
            }
            g.drawRect(topX, topY, bottomX - topX + 1, bottomY - topY + 1);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.clearBackground(g);
        this.getOwner().notifyPaintListeners(g, PaintEvent.PaintMoment.BACKGROUND);
        this.paintCoordindatesGrid(g);
        this.getOwner().notifyPaintListeners(g, PaintEvent.PaintMoment.GRID);
        this.getOwner().notifyPaintListeners(g, PaintEvent.PaintMoment.PRE_PAINT);
        this.getOwner().notifyPaintListeners(g, PaintEvent.PaintMoment.PAINT);
        this.getOwner().notifyPaintListeners(g, PaintEvent.PaintMoment.POST_PAINT);
        this.paintZoomBox(g);
    }

    public void setTipTextCustomizer(TipTextCustomizer value) {
        this.m_TipTextCustomizer = value;
    }

    public TipTextCustomizer getTipTextCustomizer() {
        return this.m_TipTextCustomizer;
    }

    public String getToolTipText(MouseEvent event) {
        String result = null;
        int count = 0;
        for (Axis axis : Axis.values()) {
            if (!this.getOwner().hasToolTipAxis(axis)) continue;
            result = count == 0 ? "" : result + ", ";
            AxisPanel panel = this.getOwner().getAxis(axis);
            this.m_Format.applyPattern(panel.getNumberFormat());
            result = result + axis.getDisplayShort() + ": ";
            result = axis == Axis.LEFT || axis == Axis.RIGHT ? result + panel.valueToDisplay(panel.posToValue(event.getY())) : result + panel.valueToDisplay(panel.posToValue(event.getX()));
            ++count;
        }
        if (this.m_TipTextCustomizer != null) {
            result = this.m_TipTextCustomizer.processTipText(this.getOwner(), event.getPoint(), result);
        }
        return result;
    }

    public void clearHitDetectors() {
        this.m_HitDetectors.clear();
    }

    public void addHitDetector(AbstractHitDetector detector) {
        this.m_HitDetectors.add(detector);
    }

    public void removeHitDetector(AbstractHitDetector detector) {
        this.m_HitDetectors.remove(detector);
    }

    protected void detectHits(MouseEvent e) {
        for (AbstractHitDetector detector : this.m_HitDetectors) {
            if (!detector.isEnabled()) continue;
            detector.detect(e);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }
}

