/*
 * Decompiled with CFR 0.152.
 */
package adams.optimise;

import adams.optimise.AbstractOptimiser;
import adams.optimise.FitnessFunction;
import adams.optimise.GridSearch;
import adams.optimise.OptData;
import adams.optimise.OptVar;

public class RefineRange
extends AbstractOptimiser {
    private static final long serialVersionUID = -7185430374252569572L;
    protected int m_Refinements;
    protected AbstractOptimiser m_optimiser;

    public String globalInfo() {
        return "Refines search space.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("refinements", "refinements", 2);
        this.m_OptionManager.add("optimiser", "optimiser", new GridSearch());
    }

    public void reset() {
        super.reset();
        if (this.getOptimiser() != null) {
            this.getOptimiser().reset();
        }
    }

    public void setOptimiser(AbstractOptimiser ao) {
        this.m_optimiser = ao;
    }

    public AbstractOptimiser getOptimiser() {
        return this.m_optimiser;
    }

    public String optimiserTipText() {
        return "optimiser";
    }

    public void setRefinements(int value) {
        this.m_Refinements = value;
    }

    public int getRefinements() {
        return this.m_Refinements;
    }

    public String refinementsTipText() {
        return "The number of refinements to apply.";
    }

    public OptData optimise(OptData datadef, FitnessFunction fitness) {
        OptData sofar = this.getOptimiser().optimise(datadef, fitness);
        for (int i = 0; i < this.getRefinements(); ++i) {
            this.debug("refinement:" + i);
            for (String var : datadef.getVarNames()) {
                OptVar ov = datadef.getVar(var);
                ov.m_max = (ov.m_max - sofar.get(var)) / 2.0 + sofar.get(var);
                ov.m_min = sofar.get(var) - (sofar.get(var) - ov.m_min) / 2.0;
            }
            sofar.cleanUp();
            sofar = this.getOptimiser().optimise(datadef, fitness);
        }
        return sofar;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_optimiser.cleanUp();
    }
}

