/*
 * BaseInteger.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core.base;

/**
 * Wrapper for an Integer object to be editable in the GOE.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 373 $
 */
public class BaseInteger
  extends BaseObject {

  /** for serialization. */
  private static final long serialVersionUID = 4461135181234402629L;

  /**
   * Initializes the string with length 0.
   */
  public BaseInteger() {
    this("0");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public BaseInteger(String s) {
    super(s);
  }

  /**
   * Checks whether the string value is a valid presentation for this class.
   *
   * @param value	the string value to check
   * @return		always true
   */
  public boolean isValid(String value) {
    try {
      Integer.parseInt(value);
      return true;
    }
    catch (Exception e) {
      return false;
    }
  }

  /**
   * Sets the string value.
   *
   * @param value	the string value
   */
  public void setValue(String value) {
    if (!isValid(value))
      return;

    try {
      m_Internal = Integer.parseInt(value);
    }
    catch (Exception e) {
      e.printStackTrace();
      m_Internal = new Integer(0);
    }
  }

  /**
   * Returns the current string value.
   *
   * @return		the string value
   */
  public String getValue() {
    return ((Integer) m_Internal).toString();
  }

  /**
   * Returns the int value.
   *
   * @return		the int value
   */
  public int intValue() {
    return ((Integer) m_Internal).intValue();
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "An integer (from " + Integer.MIN_VALUE + " to " + Integer.MAX_VALUE + ").";
  }
}
