/*
 * BaseURI.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.core.base;

import java.net.URI;

/**
 * Wrapper for an URI object to be editable in the GOE.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1469 $
 */
public class BaseURI
  extends BaseObject {

  /** for serialization. */
  private static final long serialVersionUID = 4461135181234402629L;

  /** the default URI. */
  public final static String DEFAULT_URI = "http://localhost";

  /** the current URI. */
  protected URI m_Current;

  /**
   * Initializes the string with DEFAULT_URI.
   *
   * @see		#DEFAULT_URI
   */
  public BaseURI() {
    this(DEFAULT_URI);
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public BaseURI(String s) {
    super(s);
  }

  /**
   * Checks whether the string value is a valid presentation for this class.
   *
   * @param value	the string value to check
   * @return		always true
   */
  public boolean isValid(String value) {
    try {
      new URI(value);
      return true;
    }
    catch (Exception e) {
      return false;
    }
  }

  /**
   * Sets the string value.
   *
   * @param value	the string value
   */
  public void setValue(String value) {
    if (!isValid(value))
      return;

    try {
      m_Current  = new URI(value);
      m_Internal = value;
    }
    catch (Exception e) {
      e.printStackTrace();
      m_Internal = DEFAULT_URI;
      try {
	m_Current = new URI(value);
      }
      catch (Exception ex) {
	// ignored
      }
    }
  }

  /**
   * Returns the current string value.
   *
   * @return		the string value
   */
  public String getValue() {
    return (String) m_Internal;
  }

  /**
   * Returns the URI value.
   *
   * @return		the URI value
   */
  public URI uriValue() {
    return m_Current;
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "An URI (uniform resource identifier).";
  }
}
