/*
 * PassThrough.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.data.outlier;

import java.util.Vector;

import adams.data.container.DataContainer;

/**
 <!-- globalinfo-start -->
 * A dummy detector that detects nothing.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1259 $
 */
public class PassThrough
  extends AbstractOutlierDetector {

  /** for serialization. */
  private static final long serialVersionUID = 640418515170621204L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "A dummy detector that detects nothing.";
  }

  /**
   * Performs no detecting at all.
   *
   * @param data	the data to process
   * @return		the detections
   */
  protected Vector<String> processData(DataContainer data) {
    return new Vector<String>();
  }
}
