/*
 * AllJavadoc.java
 * Copyright (C) 2006 University of Waikato, Hamilton, New Zealand
 */

package adams.doc.javadoc;

import java.util.Vector;

/**
 * Applies all known Javadoc-derived classes to a source file.
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-env &lt;java.lang.String&gt; (property: environment)
 *         The class to use for determining the environment.
 *         default: adams.core.Environment
 * </pre>
 *
 * <pre>-W &lt;java.lang.String&gt; (property: classname)
 *         The class to load.
 *         default: adams.doc.AllJavadoc
 * </pre>
 *
 * <pre>-nostars (property: useStars)
 *         Controls the use of '*' in the Javadoc.
 * </pre>
 *
 * <pre>-dir &lt;java.lang.String&gt; (property: dir)
 *         The directory above the package hierarchy of the class.
 *         default: .
 * </pre>
 *
 * <pre>-silent (property: silent)
 *         Suppresses printing in the console.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2502 $
 */
public class AllJavadoc
  extends Javadoc {

  /** for serialization. */
  private static final long serialVersionUID = 8491098698586623712L;

  /** contains all the javadoc generators. */
  protected Vector m_Javadocs;

  /**
   * Initializes the members.
   */
  protected void initialize() {
    String[] 	list;
    int 	i;
    Class 	cls;

    super.initialize();

    // instantiate all apart from itself
    list = Javadoc.getJavadocs();
    m_Javadocs = new Vector();
    for (i = 0; i < list.length; i++) {
      if (list[i].equals(AllJavadoc.class.getName()))
	continue;
      try {
	cls = Class.forName(list[i]);
	m_Javadocs.add(cls.newInstance());
      }
      catch (Exception e) {
	getSystemErr().printStackTrace(e);
      }
    }
  }

  /**
   * sets the classname of the class to generate the Javadoc for.
   *
   * @param value	the new classname
   */
  public void setClassname(String value) {
    super.setClassname(value);
    for (int i = 0; i < m_Javadocs.size(); i++)
      ((Javadoc) m_Javadocs.get(i)).setClassname(value);
  }

  /**
   * sets whether to prefix the Javadoc with "*".
   *
   * @param value	true if stars are to be used
   */
  public void setUseStars(boolean value) {
    super.setUseStars(value);
    for (int i = 0; i < m_Javadocs.size(); i++)
      ((Javadoc) m_Javadocs.get(i)).setUseStars(value);
  }

  /**
   * sets whether to suppress output in the console.
   *
   * @param value	true if output is to be suppressed
   */
  public void setSilent(boolean value) {
    super.setSilent(value);
    for (int i = 0; i < m_Javadocs.size(); i++)
      ((Javadoc) m_Javadocs.get(i)).setSilent(value);
  }

  /**
   * generates and returns the Javadoc for the specified start/end tag pair.
   *
   * @param index	the index in the start/end tag array
   * @return		the generated Javadoc
   * @throws Exception 	in case the generation fails
   */
  protected String generateJavadoc(int index) throws Exception {
    throw new Exception("Not used!");
  }

  /**
   * updates the Javadoc in the given source code, using all the found
   * Javadoc updaters.
   *
   * @param content	the source code
   * @return		the updated source code
   * @throws Exception 	in case the generation fails
   */
  protected String updateJavadoc(String content) throws Exception {
    String	result;
    int		i;

    result = content;

    for (i = 0; i < m_Javadocs.size(); i++) {
      result = ((Javadoc) m_Javadocs.get(i)).updateJavadoc(result);
    }

    return result;
  }

  /**
   * Parses the given commandline parameters and generates the Javadoc.
   *
   * @param args	the commandline parameters for the object
   */
  public static void main(String[] args) {
    runJavadoc(AllJavadoc.class, args);
  }
}
