/**
 * AbstractIfThenElseCondition.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.condition.ifthenelse;

import adams.core.ShallowCopySupporter;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;

/**
 * Ancestor for conditions that get evaluated in the IfThenElse control actor,
 * deciding which branch to take.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4008 $
 */
public abstract class AbstractIfThenElseCondition
  extends OptionHandlingObject
  implements ShallowCopySupporter<AbstractIfThenElseCondition> {

  /** for serialization. */
  private static final long serialVersionUID = 1816980432972492738L;

  /**
   * Returns the quick info string to be displayed in the flow editor.
   *
   * @return		the info or null if no info to be displayed
   */
  public abstract String getQuickInfo();

  /**
   * Returns the class that the consumer accepts.
   *
   * @return		adams.flow.core.Unknown.class
   */
  public abstract Class[] accepts();

  /**
   * Configures the condition.
   *
   * @return		null if everything is fine, otherwise error message
   */
  public abstract String setUp();

  /**
   * Evaluates whether to executed the "then" or "else" branch.
   *
   * @param owner	the owning IfThenElse actor
   * @param token	the current token passing through the IfThenElse actor
   * @return		true if to execute the "then" branch
   */
  public abstract boolean doThen(AbstractActor owner, Token token);

  /**
   * Returns a shallow copy of itself, i.e., based on the commandline options.
   *
   * @return		the shallow copy
   */
  public AbstractIfThenElseCondition shallowCopy() {
    return shallowCopy(false);
  }

  /**
   * Returns a shallow copy of itself, i.e., based on the commandline options.
   *
   * @param expand	whether to expand variables to their current values
   * @return		the shallow copy
   */
  public AbstractIfThenElseCondition shallowCopy(boolean expand) {
    return (AbstractIfThenElseCondition) OptionUtils.shallowCopy(this, expand);
  }
}
