/**
 * AbstractComponentDisplayPanel.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.sink;

import javax.swing.JComponent;

/**
 * Ancestor for panels that can be created from tokens and supply the
 * underlying component.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1010 $
 */
public abstract class AbstractComponentDisplayPanel
  extends AbstractDisplayPanel
  implements ComponentSupplier {

  /** for serialization. */
  private static final long serialVersionUID = -2404789994825903954L;

  /**
   * Initializes the panel.
   *
   * @param name	the name of the panel
   */
  public AbstractComponentDisplayPanel(String name) {
    super(name);
  }

  /**
   * Supplies the component.
   *
   * @return		the component, null if none available
   */
  public abstract JComponent supplyComponent();
}
