/**
 * PanelProvider.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.sink;

import adams.flow.core.Token;

/**
 * Interface for graphical sinks that can also generate a panel from scratch
 * for a new token.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2982 $
 */
public interface DisplayPanelProvider {

  /**
   * Creates a new display panel for the token.
   *
   * @param token	the token to display in a new panel
   * @return		the generated panel
   */
  public AbstractDisplayPanel createDisplayPanel(Token token);

  /**
   * Returns whether the created display panel requires a scroll pane or not.
   *
   * @return		true if the display panel requires a scroll pane
   */
  public boolean displayPanelRequiresScrollPane();
}
