/**
 * AbstractMarkerPaintlet.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.sink.sequenceplotter;

import java.awt.Color;
import java.awt.Graphics;

import adams.data.sequence.XYSequence;
import adams.gui.event.PaintEvent.PaintMoment;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.sequence.XYSequenceContainerList;

/**
 * Ancestor for marker paintlets.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3932 $
 */
public abstract class AbstractMarkerPaintlet
  extends AbstractPaintlet
  implements MarkerPaintlet {

  /** for serialization. */
  private static final long serialVersionUID = -4384114526759056961L;

  /** the marker list. */
  protected XYSequenceContainerList m_MarkerContainerList;

  /**
   * Returns when this paintlet is to be executed.
   *
   * @return		when this paintlet is to be executed
   */
  public PaintMoment getPaintMoment() {
    return PaintMoment.PRE_PAINT;
  }

  /**
   * Returns the plotter panel.
   *
   * @return		the plotter panel
   */
  public SequencePlotterPanel getPlotterPanel() {
    if (getPanel() instanceof SequencePlotterPanel)
      return (SequencePlotterPanel) getPanel();
    else
      return null;
  }

  /**
   * Returns the color for the data with the given index.
   *
   * @param index	the index of the spectrum
   * @return		the color for the spectrum
   */
  public Color getColor(int index) {
    return getPlotterPanel().getMarkerContainerManager().get(index).getColor();
  }

  /**
   * Draws the marker data with the given color.
   *
   * @param g		the graphics context
   * @param data	the marker data to draw
   * @param color	the color to draw in
   */
  protected abstract void drawData(Graphics g, XYSequence data, Color color);

  /**
   * The paint routine of the paintlet.
   *
   * @param g		the graphics context to use for painting
   */
  public void performPaint(Graphics g) {
    int		i;
    XYSequence 	data;

    // paint all markers
    synchronized(getPlotterPanel().getMarkerContainerManager()) {
      for (i = 0; i < getPlotterPanel().getMarkerContainerManager().count(); i++) {
	if (!getPlotterPanel().getMarkerContainerManager().isVisible(i))
	  continue;
	data = getPlotterPanel().getMarkerContainerManager().get(i).getData();
	synchronized(data) {
	  drawData(g, data, getColor(i));
	}
      }
    }
  }
}
