/**
 * SimplePruning.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.sink.sequenceplotter;

import adams.data.sequence.XYSequence;
import adams.gui.visualization.sequence.XYSequenceContainerManager;

/**
 <!-- globalinfo-start -->
 * Simply prunes the sequences at the head if they exceed a pre-defined size limit.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 * <pre>-limit &lt;int&gt; (property: limit)
 * &nbsp;&nbsp;&nbsp;The size limit for sequences; use -1 for unlimited.
 * &nbsp;&nbsp;&nbsp;default: -1
 * &nbsp;&nbsp;&nbsp;minimum: -1
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4318 $
 */
public class SimplePruning
  extends AbstractSequencePostProcessor {

  /** for serialization. */
  private static final long serialVersionUID = -7354044974316978487L;

  /** the size limit for sequences. */
  protected int m_Limit;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Simply prunes the sequences at the head if they exceed a pre-defined size limit.";
  }

  /**
   * Adds options to the internal list of options.
   */
  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	    "limit", "limit",
	    -1, -1, null);
  }

  /**
   * Sets the size limit.
   *
   * @param value	the limit
   */
  public void setLimit(int value) {
    if (value >= -1) {
      m_Limit = value;
      reset();
    }
    else {
      getSystemErr().println(
	  "Limit must be >= -1, provided: " + value);
    }
  }

  /**
   * Returns the size limit.
   *
   * @return		the limit
   */
  public int getLimit() {
    return m_Limit;
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String limitTipText() {
    return "The size limit for sequences; use -1 for unlimited.";
  }

  /**
   * Post-processes the sequences.
   *
   * @param manager	the sequence manager
   * @param plotName	the plot that was modified
   * @return		true if any sequence was modified
   */
  public boolean postProcess(XYSequenceContainerManager manager, String plotName) {
    boolean		result;
    XYSequence		seq;

    result = false;
    seq    = manager.get(manager.indexOf(plotName)).getData();
    while (seq.size() > m_Limit) {
      seq.toList().remove(0);
      result = true;
    }

    return result;
  }
}
