/*
 * NodePopupMenuCustomizer.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.flow.tree;

import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

/**
 * Interface for classes that want to customize the popup menu that is
 * displayed on nodes.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3767 $
 */
public interface NodePopupMenuCustomizer {

  /**
   * Customizes the popup menu.
   *
   * @param tree	the tree to work with
   * @param menu	the menu so far
   * @param paths	the paths in the tree that the menu is generated for
   */
  public void customizeNodePopupMenu(Tree tree, JPopupMenu menu, TreePath[] paths);
}
