/**
 * StrictClassTreeFilter.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.goe.classtree;

/**
 * Interface for filters that allow strict filtering.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3660 $
 */
public interface StrictClassTreeFilter {

  /**
   * Sets whether to use strict or relaxed filtering.
   *
   * @param value	if true strict mode is enabled
   */
  public void setStrict(boolean value);

  /**
   * Returns whether strict or relaxed filtering is used.
   *
   * @return		true if strict mode is enabled
   */
  public boolean isStrict();
}
