/**
 * DeleteData.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;


/**
 <!-- scriptlet-parameters-start -->
 * Action parameters:<br/>
 * <pre>   delete-data &lt;comma-separated list of DB-IDs&gt;</pre>
 * <p/>
 <!-- scriptlet-parameters-end -->
 *
 <!-- scriptlet-description-start -->
 * Description:
 * <pre>   Deletes the record with the specified DB-IDs from the database.</pre>
 * <p/>
 <!-- scriptlet-description-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 974 $
 */
public class DeleteData
  extends AbstractScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = 1714520838655609203L;

  /** the action to execute. */
  public final static String ACTION = "delete-data";

  /**
   * Returns the action string used in the command processor.
   *
   * @return		the action string
   */
  public String getAction() {
    return ACTION;
  }

  /**
   * Returns a one-line listing of the options of the action.
   *
   * @return		the options or null if none
   */
  protected String getOptionsDescription() {
    return "<comma-separated list of DB-IDs>";
  }

  /**
   * Returns the full description of the action.
   *
   * @return		the full description
   */
  public String getDescription() {
    return "Deletes the record with the specified DB-IDs from the database.";
  }

  /**
   * Processes the options.
   *
   * @param options	additional/optional options for the action
   * @return		null if no error, otherwise error message
   * @throws Exception 	if something goes wrong
   */
  public String process(String options) throws Exception {
    String[]		ids;
    int			i;
    boolean		result;

    ids = options.replaceAll(" ", "").split(",");
    for (i = 0; i < ids.length; i++) {
      showStatus("Deleting record " + (i+1) + "/" + ids.length + ": " + ids[i]);
      result = m_DataProvider.remove(new Integer(ids[i]));
      if (!result)
	getSystemErr().println("Error deleting record #" + ids[i]);
    }

    showStatus("");

    return null;
  }
}
