/**
 * AbstractReportHandler.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.tools.previewbrowser;

import java.io.File;

import javax.swing.JPanel;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.Report;
import adams.gui.visualization.report.ReportFactory;

/**
 * Ancestor for handlers that display reports.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 * @see Report
 */
public abstract class AbstractReportHandler
  extends AbstractContentHandler {

  /** for serialization. */
  private static final long serialVersionUID = -3800895640927273805L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Displays the following report types: " + Utils.arrayToString(getExtensions());
  }

  /**
   * Returns the reader to use.
   *
   * @param file	the file to read from
   * @return		the reader
   */
  protected abstract AbstractReportReader getReader(File file);

  /**
   * Creates the actual view.
   *
   * @param file	the file to create the view for
   * @return		the view
   */
  protected JPanel createPreview(File file) {
    ReportFactory.Panel		result;
    AbstractReportReader	reader;

    reader = getReader(file);
    reader.setInput(new PlaceholderFile(file));
    result = ReportFactory.getPanel(reader.read());

    return result;
  }

}
