/*
 * VisibilityContainerManager.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

import java.util.Vector;

/**
 * Indicator interface for container managers that manage containers
 * encapsulating visbility information as well.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 952 $
 * @param <T> tye type of container
 */
public interface VisibilityContainerManager<T extends Container> {

  /**
   * Returns (a copy of) all currently stored (visible) containers. Those containers
   * have no manager.
   *
   * @return		all containers
   */
  public Vector<T> getAllVisible();

  /**
   * Returns the indices of all visible containers.
   *
   * @return		all containers
   */
  public int[] getVisibleIndices();

  /**
   * Returns whether the container at the specified position is visible.
   *
   * @param index	the container's position
   * @return		true if the container is visible
   */
  public boolean isVisible(int index);

  /**
   * Sets the specified container's visibility.
   *
   * @param index	the index of the container
   * @param visible	if true then the container will be made visible
   */
  public void setVisible(int index, boolean visible);

  /**
   * Returns the nth visible container.
   *
   * @param index	the index (relates only to the visible containers!)
   * @return		the container, null if index out of range
   */
  public T getVisible(int index);

  /**
   * Returns the number of visible containers.
   *
   * @return		the number of visible containers
   */
  public int countVisible();
}