/*
 * DatabaseIDProcessor.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.tools;

/**
 * For tools that can process custom database IDs as well.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1632 $
 */
public interface DatabaseIDProcessor {

  /**
   * Sets the database IDs to process.
   *
   * @param value	the IDs
   */
  public void setDatabaseIDs(int[] value);

  /**
   * Returns the database IDs to process.
   *
   * @return		the IDs
   */
  public int[] getDatabaseIDs();

  /**
   * Checks whether custom database IDs have been set.
   *
   * @return		true if custom database IDs will be processed
   */
  public boolean hasDatabaseIDs();
}
