/*
 * FileExistsTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.condition;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.io.PlaceholderDirectory;
import adams.env.Environment;

/**
 * Tests the DirExists condition.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2208 $
 */
public class DirExistsTest
  extends AbstractConditionTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public DirExistsTest(String name) {
    super(name);
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractCondition[] getRegressionSetups() {
    DirExists[]	result;

    result = new DirExists[4];

    result[0] = new DirExists();
    result[0].setDirectory(new PlaceholderDirectory("${TMP}"));

    result[1] = new DirExists();
    result[1].setDirectory(new PlaceholderDirectory("${TMP}/blahblah"));

    result[2] = new DirExists();
    result[2].setDirectory(new PlaceholderDirectory("${TMP}"));
    result[2].setInvert(true);

    result[3] = new DirExists();
    result[3].setDirectory(new PlaceholderDirectory("${TMP}/blahblah"));
    result[3].setInvert(true);

    return result;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(DirExistsTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
