/*
 * SwitchTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.control;

import java.io.File;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.base.BaseString;
import adams.data.random.JavaRandomInt;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.RandomNumberGenerator;
import adams.test.TmpFile;

/**
 * Tests the Switch actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2208 $
 */
public class SwitchTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public SwitchTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("dumpfile-300.txt");
    m_TestHelper.deleteFileFromTmp("dumpfile-600.txt");
    m_TestHelper.deleteFileFromTmp("dumpfile-default.txt");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    RandomNumberGenerator rng = new RandomNumberGenerator();
    rng.setGenerator(new JavaRandomInt());

    DumpFile df300 = new DumpFile();
    df300.setAppend(true);
    df300.setOutputFile(new TmpFile("dumpfile-300.txt"));

    DumpFile df600 = new DumpFile();
    df600.setAppend(true);
    df600.setOutputFile(new TmpFile("dumpfile-600.txt"));

    DumpFile dfDef = new DumpFile();
    dfDef.setAppend(true);
    dfDef.setOutputFile(new TmpFile("dumpfile-default.txt"));

    Switch sw = new Switch();
    sw.setExpressions(
	new BaseString[]{
	    new BaseString("X < 300"),
	    new BaseString("X < 600")
	});
    sw.setCases(
	new AbstractActor[]{
	    df300,
	    df600,
	    dfDef
	});

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{rng, sw});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new File[]{
	    new TmpFile("dumpfile-300.txt"),
	    new TmpFile("dumpfile-600.txt"),
	    new TmpFile("dumpfile-default.txt")});
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(SwitchTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
