/**
 * BaseTimeExpressionTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.parser;

import java.text.SimpleDateFormat;
import java.util.Date;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.base.BaseTime;
import adams.env.Environment;

/**
 * Tests the adams.parser.BaseTimeExpression class. Run from commandline with: <p/>
 * java adams.parser.BaseTimeExpressionTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2208 $
 */
public class BaseTimeExpressionTest
  extends AbstractExpressionEvaluatorTestCase<Date, BaseTimeExpression> {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public BaseTimeExpressionTest(String name) {
    super(name);
  }

  /**
   * Returns the expressions used in the regression test.
   *
   * @return		the data
   */
  protected String[][] getRegressionExpressions() {
    return new String[][]{
	{
	  "-INF",
	  "+INF",
	  "01:02:03 +1 SECOND",
	  "01:02:03 +1 MINUTE",
	  "01:02:03 +1 HOUR",
	  "01:02:03 -1 SECOND",
	  "01:02:03 -1 MINUTE",
	  "01:02:03 -1 HOUR",
	  "01:02:03",
	  "START +1 HOUR",
	  "END -1 HOUR"
	}
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected BaseTimeExpression[] getRegressionSetups() {
    return new BaseTimeExpression[]{new BaseTimeExpression()};
  }

  /**
   * Tests setitng the START variable programmatically.
   */
  public static void testStart() {
    String expr = "START +1 HOUR +1 SECOND";
    SimpleDateFormat format = new SimpleDateFormat(BaseTime.FORMAT);
    String startStr = "12:34:00";
    Date start = null;
    Date parsed = null;
    try {
      start = format.parse(startStr);
    }
    catch (Exception e) {
      fail("Failed to generate Date object from '" + startStr + "': " + e);
    }
    try {
      parsed = BaseDateTimeExpression.evaluate(expr, start, null);
    }
    catch (Exception e) {
      fail("Failed to parse expression '" + expr + "': " + e);
    }
    assertNotNull("Generated null date", parsed);
    assertEquals("Generated different date", "13:34:01", format.format(parsed));
  }

  /**
   * Tests setitng the END variable programmatically.
   */
  public static void testEnd() {
    String expr = "END -1 HOUR -1 SECOND";
    SimpleDateFormat format = new SimpleDateFormat(BaseTime.FORMAT);
    String endStr = "12:34:00";
    Date end = null;
    Date parsed = null;
    try {
      end = format.parse(endStr);
    }
    catch (Exception e) {
      fail("Failed to generate Date object from '" + endStr + "': " + e);
    }
    try {
      parsed = BaseDateTimeExpression.evaluate(expr, null, end);
    }
    catch (Exception e) {
      fail("Failed to parse expression '" + expr + "': " + e);
    }
    assertNotNull("Generated null date", parsed);
    assertEquals("Generated different date", "11:33:59", format.format(parsed));
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(BaseTimeExpressionTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
