/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.ByteFormat;
import adams.core.Utils;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ByteFormatTest
extends AdamsTestCase {
    public ByteFormatTest(String name) {
        super(name);
    }

    protected void performSerializableTest(Class cls) {
        ByteFormatTest.assertNotNull((String)"Serialization failed", (Object)Utils.deepCopy((Object)new ByteFormat("BK")));
    }

    public void testEmptyFormat() {
        ByteFormat b = new ByteFormat("");
        ByteFormatTest.assertNull((String)"format is not null", (Object)b.getFormat());
    }

    public void testInvalidFormat() {
        ByteFormat b = new ByteFormat("hello world");
        ByteFormatTest.assertNull((String)"format is not null", (Object)b.getFormat());
    }

    public void testKiloBytes() {
        ByteFormat b = new ByteFormat("bk");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1", (String)b.format(1024L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2", (String)b.format(2048L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2", (String)b.format(2200L));
        b = new ByteFormat("bK");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1KB", (String)b.format(1024L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2KB", (String)b.format(2048L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2KB", (String)b.format(2200L));
        b = new ByteFormat("b.1K");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1.0KB", (String)b.format(1024L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.0KB", (String)b.format(2048L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.1KB", (String)b.format(2200L));
        b = new ByteFormat("b.2K");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1.00KB", (String)b.format(1024L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.00KB", (String)b.format(2048L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.14KB", (String)b.format(2200L));
    }

    public void testMegaBytes() {
        ByteFormat b = new ByteFormat("bm");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1", (String)b.format(0x100000L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2", (String)b.format(0x200000L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2", (String)b.format(0x226000L));
        b = new ByteFormat("bM");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1MB", (String)b.format(0x100000L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2MB", (String)b.format(0x200000L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2MB", (String)b.format(0x226000L));
        b = new ByteFormat("b.1M");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1.0MB", (String)b.format(0x100000L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.0MB", (String)b.format(0x200000L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.1MB", (String)b.format(0x226000L));
        b = new ByteFormat("b.2M");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1.00MB", (String)b.format(0x100000L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.00MB", (String)b.format(0x200000L));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.14MB", (String)b.format(0x226000L));
    }

    public void testGigaBytes() {
        ByteFormat b = new ByteFormat("bg");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1", (String)b.format(1.073741824E9));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2", (String)b.format(2.147483648E9));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2", (String)b.format(2.3068672E9));
        b = new ByteFormat("bG");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1GB", (String)b.format(1.073741824E9));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2GB", (String)b.format(2.147483648E9));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2GB", (String)b.format(2.3068672E9));
        b = new ByteFormat("b.1G");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1.0GB", (String)b.format(1.073741824E9));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.0GB", (String)b.format(2.147483648E9));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.1GB", (String)b.format(2.3068672E9));
        b = new ByteFormat("b.2G");
        ByteFormatTest.assertNotNull((String)"format is null", (Object)b.getFormat());
        ByteFormatTest.assertEquals((String)"output differs", (String)"1.00GB", (String)b.format(1.073741824E9));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.00GB", (String)b.format(2.147483648E9));
        ByteFormatTest.assertEquals((String)"output differs", (String)"2.14GB", (String)b.format(2.3068672E9));
    }

    public static Test suite() {
        return new TestSuite(ByteFormatTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ByteFormatTest.runTest(ByteFormatTest.suite());
    }
}

