/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.conversion.AbstractConversion;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractConversionTestCase
extends AbstractDatabaseTestCase {
    public AbstractConversionTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/data/conversion/data");
    }

    protected Object[] process(Object data, AbstractConversion scheme) {
        Object[] result = new Object[2];
        scheme.setInput(data);
        String msg = scheme.convert();
        if (msg == null) {
            result[0] = scheme.getOutput();
        } else {
            result[1] = msg;
        }
        return result;
    }

    protected String toString(Object data) {
        return data.toString();
    }

    protected boolean save(Object data, String filename, boolean append) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data.toString(), (boolean)append);
    }

    protected abstract Object[] getRegressionInput();

    protected abstract AbstractConversion[] getRegressionSetups();

    protected abstract int[] getRegressionIgnoredLineIndices();

    protected String createOutputFilename(int no) {
        return "out-" + no + ".txt";
    }

    public void testRegression() {
        int i;
        Object[] input = this.getRegressionInput();
        AbstractConversion[] setups = this.getRegressionSetups();
        String[] output = new String[setups.length];
        int[] ignored = this.getRegressionIgnoredLineIndices();
        for (int n = 0; n < setups.length; ++n) {
            output[n] = this.createOutputFilename(n);
            AbstractConversion current = (AbstractConversion)OptionUtils.shallowCopy((OptionHandler)setups[n], (boolean)false);
            boolean append = false;
            AbstractConversionTestCase.assertNotNull((String)("Failed to create copy of conversion algorithm: " + OptionUtils.getCommandLine((Object)setups[n])), (Object)current);
            for (i = 0; i < input.length; ++i) {
                Object[] processed = this.process(input[i], current);
                AbstractConversionTestCase.assertNull((String)("Failed to process data: " + processed[1]), (Object)processed[1]);
                if (processed[0] == null) continue;
                boolean ok = this.save(this.toString(processed[0]), output[n], append);
                AbstractConversionTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
                append = true;
            }
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, ignored);
        AbstractConversionTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

