/*
 * Decompiled with CFR 0.152.
 */
package adams.flow;

import adams.env.Environment;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.gui.core.BaseFrame;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.scripting.ScriptingEngine;
import adams.test.AbstractFileStressTest;
import adams.test.AbstractStressTest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

public class StressTestFlow
extends AbstractFileStressTest {
    private static final long serialVersionUID = -2535320030771462923L;
    protected boolean m_UseGUI;
    protected FlowEditorPanel m_Panel;
    protected BaseFrame m_Frame;

    public String globalInfo() {
        return "Class for stress-testing flows.\nDefault is to test without FlowEditor panel.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-gui", "useGUI", (Object)false);
    }

    public void setUseGUI(boolean value) {
        this.m_UseGUI = value;
        this.reset();
    }

    public boolean getUseGUI() {
        return this.m_UseGUI;
    }

    public String useJmapTipText() {
        return "Whether to run tests in GUI.";
    }

    protected AbstractStressTest.Worker setupWorker(int iteration) {
        AbstractStressTest.Worker result = new AbstractStressTest.Worker(this, iteration){
            protected AbstractActor m_Flow;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground() throws Exception {
                if (StressTestFlow.this.m_UseGUI) {
                    if (StressTestFlow.this.m_Panel == null) {
                        StressTestFlow.this.m_Panel = new FlowEditorPanel();
                        StressTestFlow.this.m_Frame = new BaseFrame();
                        StressTestFlow.this.m_Frame.getContentPane().setLayout(new BorderLayout());
                        StressTestFlow.this.m_Frame.getContentPane().add((Component)StressTestFlow.this.m_Panel, "Center");
                        StressTestFlow.this.m_Frame.setSize(600, 400);
                        StressTestFlow.this.m_Frame.setLocationRelativeTo(null);
                        StressTestFlow.this.m_Frame.setVisible(true);
                    }
                    StressTestFlow.this.m_Panel.loadUnsafe((File)((AbstractFileStressTest)this.m_Owner).getFile());
                    while (StressTestFlow.this.m_Panel.isSwingWorkerRunning()) {
                        try {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(100L);
                            }
                        }
                        catch (Exception e) {
                        }
                    }
                    StressTestFlow.this.m_Panel.run(false);
                    while (StressTestFlow.this.m_Panel.isRunning() || !StressTestFlow.this.m_Panel.isRunning() && StressTestFlow.this.m_Panel.isStopping()) {
                        try {
                            1 e = this;
                            synchronized (e) {
                                this.wait(100L);
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                } else {
                    this.m_Flow = ActorUtils.read((String)((AbstractFileStressTest)this.m_Owner).getFile().getAbsolutePath());
                    this.m_Flow.setUp();
                    this.m_Flow.execute();
                }
                return null;
            }

            protected void done() {
                if (StressTestFlow.this.m_UseGUI) {
                    StressTestFlow.this.m_Panel.getCurrentPanel().close();
                    StressTestFlow.this.m_Panel.cleanUp();
                } else {
                    this.m_Flow.wrapUp();
                    this.m_Flow.destroy();
                    this.m_Flow = null;
                }
                super.done();
            }

            public void stopExecution() {
                if (StressTestFlow.this.m_UseGUI) {
                    StressTestFlow.this.m_Panel.stop();
                } else {
                    this.m_Flow.stopExecution();
                }
            }
        };
        return result;
    }

    protected void postExecute() {
        ScriptingEngine.stopAllEngines();
        if (this.m_Frame != null) {
            this.m_Frame.dispose();
        }
    }

    public static void main(String[] args) {
        StressTestFlow.runStressTester(Environment.class, StressTestFlow.class, args);
    }
}

