/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.PassThrough;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PassThroughTest
extends AbstractFlowTest {
    public PassThroughTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3"), new BaseString("4")});
        PassThrough pt = new PassThrough();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, pt, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(PassThroughTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        PassThroughTest.runTest(PassThroughTest.suite());
    }
}

