/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.env.Environment;
import adams.parser.AbstractExpressionEvaluatorTestCase;
import adams.parser.BaseDateTimeExpression;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDateTimeExpressionTest
extends AbstractExpressionEvaluatorTestCase<Date, BaseDateTimeExpression> {
    public BaseDateTimeExpressionTest(String name) {
        super(name);
    }

    @Override
    protected String[][] getRegressionExpressions() {
        return new String[][]{{"-INF", "+INF", "1999-12-31 01:02:03 +1 SECOND", "1999-12-31 01:02:03 +1 MINUTE", "1999-12-31 01:02:03 +1 HOUR", "1999-12-31 01:02:03 +1 DAY", "1999-12-31 01:02:03 +1 WEEK", "1999-12-31 01:02:03 +1 MONTH", "1999-12-31 01:02:03 +1 YEAR", "1999-12-31 01:02:03 -1 SECOND", "1999-12-31 01:02:03 -1 MINUTE", "1999-12-31 01:02:03 -1 HOUR", "1999-12-31 01:02:03 -1 DAY", "1999-12-31 01:02:03 -1 WEEK", "1999-12-31 01:02:03 -1 MONTH", "1999-12-31 01:02:03 -1 YEAR", "1999-12-31 01:02:03", "START +1 HOUR +1 DAY", "END -1 HOUR -1 DAY"}};
    }

    protected BaseDateTimeExpression[] getRegressionSetups() {
        return new BaseDateTimeExpression[]{new BaseDateTimeExpression()};
    }

    public static void testStart() {
        String expr = "START +2 DAY +1 MONTH +1 HOUR";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startStr = "1901-01-01 12:34:00";
        Date start = null;
        Date parsed = null;
        try {
            start = format.parse(startStr);
        }
        catch (Exception e) {
            BaseDateTimeExpressionTest.fail((String)("Failed to generate Date object from '" + startStr + "': " + e));
        }
        try {
            parsed = BaseDateTimeExpression.evaluate((String)expr, (Date)start, null);
        }
        catch (Exception e) {
            BaseDateTimeExpressionTest.fail((String)("Failed to parse expression '" + expr + "': " + e));
        }
        BaseDateTimeExpressionTest.assertNotNull((String)"Generated null date", (Object)parsed);
        BaseDateTimeExpressionTest.assertEquals((String)"Generated different date", (String)"1901-02-03 13:34:00", (String)format.format(parsed));
    }

    public static void testEnd() {
        String expr = "END -2 DAY -1 MONTH -1 HOUR";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String endStr = "1901-10-27 12:34:00";
        Date end = null;
        Date parsed = null;
        try {
            end = format.parse(endStr);
        }
        catch (Exception e) {
            BaseDateTimeExpressionTest.fail((String)("Failed to generate Date object from '" + endStr + "': " + e));
        }
        try {
            parsed = BaseDateTimeExpression.evaluate((String)expr, null, (Date)end);
        }
        catch (Exception e) {
            BaseDateTimeExpressionTest.fail((String)("Failed to parse expression '" + expr + "': " + e));
        }
        BaseDateTimeExpressionTest.assertNotNull((String)"Generated null date", (Object)parsed);
        BaseDateTimeExpressionTest.assertEquals((String)"Generated different date", (String)"1901-09-25 11:34:00", (String)format.format(parsed));
    }

    public static Test suite() {
        return new TestSuite(BaseDateTimeExpressionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseDateTimeExpressionTest.runTest(BaseDateTimeExpressionTest.suite());
    }
}

