/*
 * Decompiled with CFR 0.152.
 */
package adams.test;

import adams.core.Properties;
import adams.core.base.BasePassword;
import adams.db.AbstractDatabaseConnection;
import adams.db.AbstractIndexedTable;
import adams.test.AdamsTestCase;
import java.util.Hashtable;

public abstract class AbstractDatabaseTestCase
extends AdamsTestCase {
    protected Properties m_Properties;
    protected static Hashtable<String, Boolean> m_TablesInitialized = new Hashtable();

    public AbstractDatabaseTestCase(String name) {
        super(name);
    }

    protected String getDatabasePropertiesFile() {
        return "adams/test/TestDatabase.props";
    }

    protected synchronized Properties getDatabaseProperties(String file) {
        if (this.m_Properties == null) {
            try {
                this.m_Properties = Properties.read((String)file);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_Properties = new Properties();
            }
        }
        return this.m_Properties;
    }

    public synchronized Properties getDatabaseProperties() {
        return this.getDatabaseProperties(this.getDatabasePropertiesFile());
    }

    public String getDatabaseURL() {
        return this.getDatabaseProperties().getProperty("DatabaseURL");
    }

    public String getDatabaseUser() {
        return this.getDatabaseProperties().getProperty("DatabaseUser");
    }

    public BasePassword getDatabasePassword() {
        return new BasePassword(this.getDatabaseProperties().getProperty("DatabasePassword"));
    }

    protected synchronized void connect() {
        this.m_TestHelper.connect(this.getDatabaseURL(), this.getDatabaseUser(), this.getDatabasePassword());
        this.initTables();
        this.postConnect();
    }

    protected void postConnect() {
        this.m_TestHelper.postConnect();
    }

    protected synchronized void reconnect() {
        this.reconnect(this.getDatabasePropertiesFile());
    }

    protected synchronized void reconnect(String file) {
        this.m_Properties = null;
        this.getDatabaseProperties(file);
        this.connect();
    }

    protected void initTables() {
        if (!m_TablesInitialized.containsKey(this.getDatabaseURL())) {
            m_TablesInitialized.put(this.getDatabaseURL(), false);
        }
        if (!m_TablesInitialized.get(this.getDatabaseURL()).booleanValue()) {
            AbstractIndexedTable.initTables((AbstractDatabaseConnection)this.getDatabaseConnection());
            m_TablesInitialized.put(this.getDatabaseURL(), true);
        }
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_TestHelper.getDatabaseConnection(this.getDatabaseURL(), this.getDatabaseUser(), this.getDatabasePassword());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.connect();
    }
}

