/*
 * Decompiled with CFR 0.152.
 */
package adams.test;

import adams.core.base.BasePassword;
import adams.core.io.FileUtils;
import adams.data.container.DataContainer;
import adams.db.AbstractDatabaseConnection;
import adams.test.AdamsTestCase;
import adams.test.AdamsTestSuite;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestHelper<I extends DataContainer, O> {
    protected AdamsTestCase m_Owner;
    protected String m_DataDirectory;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public AbstractTestHelper(AdamsTestCase owner, String dataDir) {
        this.m_Owner = owner;
        this.m_DataDirectory = dataDir;
        this.m_DatabaseConnection = null;
    }

    public String getDataDirectory() {
        return this.m_DataDirectory;
    }

    public String getTmpDirectory() {
        return AdamsTestSuite.getTmpDirectory();
    }

    public String getTmpLocationFromResource(String resource) {
        File file = new File(resource);
        String result = this.getTmpDirectory() + File.separator + file.getName();
        return result;
    }

    public boolean copyResourceToTmp(String resource) {
        boolean result;
        BufferedInputStream input = null;
        FilterOutputStream output = null;
        resource = this.getDataDirectory() + "/" + resource;
        try {
            int read;
            input = new BufferedInputStream(ClassLoader.getSystemResourceAsStream(resource));
            output = new BufferedOutputStream(new FileOutputStream(this.getTmpLocationFromResource(resource)));
            byte[] buffer = new byte[1024];
            while ((read = input.read(buffer)) != -1) {
                ((BufferedOutputStream)output).write(buffer, 0, read);
                if (read >= buffer.length) continue;
            }
            result = true;
        }
        catch (IOException e) {
            if (e.getMessage().equals("Stream closed")) {
                String ext = resource.replaceAll(".*\\.", "");
                System.err.println("Resource '" + resource + "' not available? " + "Or extension '*." + ext + "' not in pom.xml ('project.build.testSourceDirectory') listed?");
            }
            e.printStackTrace();
            result = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean copyResourceToTmp(String resource, String newName) {
        boolean result = this.copyResourceToTmp(resource);
        if (result) {
            result = this.renameTmpFile(resource, newName);
        }
        return result;
    }

    public boolean deleteFileFromTmp(String filename) {
        boolean result = true;
        File file = new File(this.getTmpDirectory() + File.separator + filename);
        if (file.exists()) {
            result = file.delete();
        }
        return result;
    }

    public boolean renameTmpFile(String oldName, String newName) {
        boolean result = true;
        File oldFile = new File(this.getTmpDirectory() + File.separator + oldName);
        if (oldFile.exists()) {
            File newFile = new File(this.getTmpDirectory() + File.separator + newName);
            try {
                FileUtils.move((File)oldFile, (File)newFile);
                result = newFile.exists();
            }
            catch (Exception e) {
                System.err.println("Failed to move file '" + oldFile + "' to '" + newFile + "':");
                e.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    public abstract I load(String var1);

    public abstract boolean save(O var1, String var2);

    public abstract AbstractDatabaseConnection getDatabaseConnection(String var1, String var2, BasePassword var3);

    public abstract void connect(String var1, String var2, BasePassword var3);

    protected void postConnect() {
    }
}

