/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumericOption<T extends Number>
extends AbstractArgumentOption {
    private static final long serialVersionUID = 5499914416554286605L;
    protected T m_LowerBound;
    protected T m_UpperBound;

    protected AbstractNumericOption(OptionManager owner, String commandline, String property, Object defValue) {
        this(owner, commandline, property, defValue, true);
    }

    protected AbstractNumericOption(OptionManager owner, String commandline, String property, Object defValue, boolean outputDefValue) {
        this(owner, commandline, property, defValue, outputDefValue, null, null);
    }

    protected AbstractNumericOption(OptionManager owner, String commandline, String property, Object defValue, T lower, T upper) {
        this(owner, commandline, property, defValue, true, lower, upper);
    }

    protected AbstractNumericOption(OptionManager owner, String commandline, String property, Object defValue, boolean outputDefValue, T lower, T upper) {
        super(owner, commandline, property, defValue, outputDefValue);
        this.m_LowerBound = lower;
        this.m_UpperBound = upper;
    }

    public boolean hasLowerBound() {
        return this.m_LowerBound != null;
    }

    public T getLowerBound() {
        return this.m_LowerBound;
    }

    public boolean hasUpperBound() {
        return this.m_UpperBound != null;
    }

    public T getUpperBound() {
        return this.m_UpperBound;
    }

    @Override
    protected boolean compareValues(Object value, Object defValue) {
        Number numValue = (Number)value;
        Number numDefValue = (Number)defValue;
        return numValue.doubleValue() == numDefValue.doubleValue();
    }

    protected T checkBounds(T number) {
        Object result = number;
        boolean invalid = false;
        if (this.hasLowerBound() && ((Number)number).doubleValue() < ((Number)this.getLowerBound()).doubleValue()) {
            invalid = true;
        }
        if (this.hasUpperBound() && ((Number)number).doubleValue() > ((Number)this.getUpperBound()).doubleValue()) {
            invalid = true;
        }
        if (invalid) {
            result = (Number)this.getDefaultValue();
        }
        return result;
    }

    public T valueOf(String s) throws Exception {
        Number result;
        if (this.m_BaseClass == Byte.class || this.m_BaseClass == Byte.TYPE) {
            result = this.checkBounds(Byte.valueOf(s));
        } else if (this.m_BaseClass == Short.class || this.m_BaseClass == Short.TYPE) {
            result = this.checkBounds(Short.valueOf(s));
        } else if (this.m_BaseClass == Integer.class || this.m_BaseClass == Integer.TYPE) {
            result = this.checkBounds(Integer.valueOf(s));
        } else if (this.m_BaseClass == Long.class || this.m_BaseClass == Long.TYPE) {
            result = this.checkBounds(Long.valueOf(s));
        } else if (this.m_BaseClass == Float.class || this.m_BaseClass == Float.TYPE) {
            result = this.checkBounds(Float.valueOf(s));
        } else if (this.m_BaseClass == Double.class || this.m_BaseClass == Double.TYPE) {
            result = this.checkBounds(Double.valueOf(s));
        } else {
            throw new IllegalArgumentException("Unhandled numeric type: " + this.m_BaseClass);
        }
        return (T)result;
    }

    @Override
    public String toString(Object obj) {
        String result;
        if (this.m_BaseClass == Byte.class || this.m_BaseClass == Byte.TYPE) {
            result = Byte.toString((Byte)obj);
        } else if (this.m_BaseClass == Short.class || this.m_BaseClass == Short.TYPE) {
            result = Short.toString((Short)obj);
        } else if (this.m_BaseClass == Integer.class || this.m_BaseClass == Integer.TYPE) {
            result = Integer.toString((Integer)obj);
        } else if (this.m_BaseClass == Long.class || this.m_BaseClass == Long.TYPE) {
            result = Long.toString((Long)obj);
        } else if (this.m_BaseClass == Float.class || this.m_BaseClass == Float.TYPE) {
            result = Float.toString(((Float)obj).floatValue());
        } else if (this.m_BaseClass == Double.class || this.m_BaseClass == Double.TYPE) {
            result = Double.toString((Double)obj);
        } else {
            throw new IllegalArgumentException("Unhandled numeric type: " + this.m_BaseClass);
        }
        return result;
    }
}

