/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.DateFormat;
import adams.core.management.Java;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractRecursiveOptionProducer;
import adams.core.option.BlacklistedOptionProducer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import adams.env.Revisions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedProducer
extends AbstractRecursiveOptionProducer<Vector, Vector>
implements BlacklistedOptionProducer {
    private static final long serialVersionUID = 7096746086060792830L;
    public static final String COMMENT = "#";
    protected Class[] m_Blacklisted;
    protected boolean m_OutputProlog;
    protected boolean m_OutputClasspath;
    protected static DateFormat m_DateFormat = new DateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String globalInfo() {
        return "Generates the nested format (tab indentation in string representation, nested Vector objects in object representation).";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Blacklisted = new Class[0];
        this.m_OutputProlog = true;
        this.m_OutputClasspath = false;
    }

    @Override
    public void setBlacklisted(Class[] value) {
        if (value == null) {
            value = new Class[]{};
        }
        this.m_Blacklisted = value;
    }

    @Override
    public Class[] getBlacklisted() {
        return this.m_Blacklisted;
    }

    public void setOutputProlog(boolean value) {
        this.m_OutputProlog = value;
    }

    public boolean getOutputProlog() {
        return this.m_OutputProlog;
    }

    public String outputPrologTipText() {
        return "Whether to output the prolog with comments about software version, date/time of generation, etc.";
    }

    public void setOutputClasspath(boolean value) {
        this.m_OutputClasspath = value;
    }

    public boolean getOutputClasspath() {
        return this.m_OutputClasspath;
    }

    public String outputClasspathTipText() {
        return "Whether to output the classpath in the comments as well.";
    }

    @Override
    protected Vector initOutput() {
        return new Vector();
    }

    @Override
    public Vector processOption(BooleanOption option) {
        Vector<String> result = new Vector<String>();
        try {
            Object currValue = this.getCurrentValue(option);
            if (!((Boolean)currValue).equals((Boolean)option.getDefaultValue())) {
                result.add(this.getOptionIdentifier(option));
            }
        }
        catch (Exception e) {
            System.err.println("Error obtaining current value for '" + option.getProperty() + "':");
            e.printStackTrace();
        }
        if (result.size() > 0) {
            if (this.m_Nesting.empty()) {
                ((Vector)this.m_Output).addAll(result);
            } else {
                ((Vector)this.m_Nesting.peek()).addAll(result);
            }
        }
        return result;
    }

    @Override
    public Vector processOption(ClassOption option) {
        Vector<Object> result = new Vector<Object>();
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            result.add(this.getOptionIdentifier(option));
            result.add(option.getVariable());
        } else {
            Object currValue = this.getCurrentValue(option);
            if (!this.isDefaultValue(option, currValue)) {
                Object currValues = null;
                if (currValue != null) {
                    if (!option.isMultiple()) {
                        currValues = Array.newInstance(option.getBaseClass(), 1);
                        Array.set(currValues, 0, currValue);
                    } else {
                        currValues = currValue;
                    }
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        Object value = Array.get(currValues, i);
                        result.add(this.getOptionIdentifier(option));
                        Vector<Object> nested = new Vector<Object>();
                        result.add(nested);
                        nested.add(value.getClass().getName());
                        Vector<String> nestedDeeper = new Vector<String>();
                        nested.add(nestedDeeper);
                        if (value instanceof OptionHandler) {
                            this.m_Nesting.push(nested);
                            this.m_Nesting.push(nestedDeeper);
                            this.doProduce(((OptionHandler)value).getOptionManager());
                            this.m_Nesting.pop();
                            this.m_Nesting.pop();
                            continue;
                        }
                        AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(value);
                        nestedDeeper.addAll(Arrays.asList(handler.getOptions(value)));
                    }
                }
            }
        }
        if (this.m_Nesting.empty()) {
            ((Vector)this.m_Output).addAll(result);
        } else {
            ((Vector)this.m_Nesting.peek()).addAll(result);
        }
        return result;
    }

    @Override
    public Vector processOption(AbstractArgumentOption option) {
        Vector<String> result = new Vector<String>();
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            result.add(this.getOptionIdentifier(option));
            result.add(option.getVariable());
        } else {
            Object currValue = this.getCurrentValue(option);
            if (!this.isDefaultValue(option, currValue)) {
                Object currValues = null;
                if (currValue != null) {
                    if (!option.isMultiple()) {
                        currValues = Array.newInstance(option.getBaseClass(), 1);
                        Array.set(currValues, 0, currValue);
                    } else {
                        currValues = currValue;
                    }
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        result.add(this.getOptionIdentifier(option));
                        result.add(option.toString(Array.get(currValues, i)));
                    }
                }
            }
        }
        if (result.size() > 0) {
            if (this.m_Nesting.empty()) {
                ((Vector)this.m_Output).addAll(result);
            } else {
                ((Vector)this.m_Nesting.peek()).addAll(result);
            }
        }
        return result;
    }

    protected String getIndentation(int level) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            result.append("\t");
        }
        return result.toString();
    }

    protected void nestedToLines(Vector nested, Vector<String> lines, int level) {
        for (int i = 0; i < nested.size(); ++i) {
            if (nested.get(i) instanceof String) {
                lines.add(this.getIndentation(level) + nested.get(i));
                continue;
            }
            this.nestedToLines((Vector)nested.get(i), lines, level + 1);
        }
    }

    public Vector<String> nestedToLines(Vector nested) {
        Vector<String> result = new Vector<String>();
        this.nestedToLines(nested, result, 0);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result;
        try {
            result = new StringBuilder();
            Vector<String> lines = this.nestedToLines((Vector)this.getOutput());
            if (this.m_OutputProlog) {
                result.append("# Project: " + Environment.getInstance().getProject() + "\n");
                result.append("# Date: " + m_DateFormat.format(new Date()) + "\n");
                result.append("# User: " + System.getProperty("user.name") + "\n");
                if (this.m_OutputClasspath) {
                    result.append("# Class-Path: " + Java.getClassPath(true) + "\n");
                }
                Enumeration<String> enm = Revisions.getSingleton().names();
                while (enm.hasMoreElements()) {
                    String name = enm.nextElement();
                    result.append("# Revision/" + name + ": " + Revisions.getSingleton().get(name) + "\n");
                }
                result.append("#\n");
            }
            for (int i = 0; i < lines.size(); ++i) {
                result.append(lines.get(i));
                result.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    @Override
    protected void preProduce() {
        super.preProduce();
        ((Vector)this.m_Output).clear();
        ((Vector)this.m_Output).add(this.m_Input.getClass().getName());
        Vector nested = new Vector();
        ((Vector)this.m_Output).add(nested);
        this.m_Nesting.push(nested);
    }

    @Override
    public Vector doProduce(AbstractOption option) {
        for (int i = 0; i < this.m_Blacklisted.length; ++i) {
            if (option.getReadMethod().getReturnType() != this.m_Blacklisted[i]) continue;
            return null;
        }
        return (Vector)super.doProduce(option);
    }

    @Override
    protected void postProduce() {
        super.postProduce();
        this.m_Nesting.pop();
    }
}

