/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;

public class Maximum
extends AbstractConversion {
    private static final long serialVersionUID = -75389769071359850L;
    protected double m_Maximum;

    public String globalInfo() {
        return "If the numbers passing through get above the defined maximum, the maximum is returned instead.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("maximum", "maximum", Double.MAX_VALUE);
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.reset();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The guaranteed maximum of the numbers being output: if value being passed through gets above this threshold, this maximum is forwarded instead.";
    }

    public Class accepts() {
        return Number.class;
    }

    public Class generates() {
        return Double.class;
    }

    protected Object doConvert() throws Exception {
        double value = ((Number)this.m_Input).doubleValue();
        if (value > this.m_Maximum) {
            return this.m_Maximum;
        }
        return value;
    }
}

