/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;

public class StringToField
extends AbstractConversion {
    private static final long serialVersionUID = 8828591710515484463L;
    protected DataType m_DefaultDataType;

    public String globalInfo() {
        return "Turns a String into a Field object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("default-data-type", "defaultDataType", DataType.UNKNOWN);
    }

    public void setDefaultDataType(DataType value) {
        this.m_DefaultDataType = value;
        this.reset();
    }

    public DataType getDefaultDataType() {
        return this.m_DefaultDataType;
    }

    public String defaultDataTypeTipText() {
        return "The default data type to use for overrding " + DataType.UNKNOWN + " if the string does not have a data type definition appended.";
    }

    public Class accepts() {
        return String.class;
    }

    public Class generates() {
        return Field.class;
    }

    protected Object doConvert() throws Exception {
        AbstractField result = Field.parseField((String)this.m_Input);
        if (this.m_DefaultDataType != DataType.UNKNOWN && result.getDataType() == DataType.UNKNOWN) {
            result = new Field(result.getName(), this.m_DefaultDataType);
        }
        return result;
    }
}

