/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataContainer;
import adams.data.filter.AbstractDatabaseConnectionFilter;
import adams.data.smoothing.AbstractSmoother;
import adams.data.smoothing.PassThrough;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Smoothing<T extends DataContainer>
extends AbstractDatabaseConnectionFilter<T> {
    private static final long serialVersionUID = -3912578009638673851L;
    protected AbstractSmoother m_Smoother;

    @Override
    public String globalInfo() {
        return "A filter that runs a smoothing scheme over the data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("smoother", "smoother", new PassThrough());
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setSmoother(AbstractSmoother value) {
        this.m_Smoother = value;
        this.updateDatabaseConnection();
        this.reset();
    }

    public AbstractSmoother getSmoother() {
        return this.m_Smoother;
    }

    public String smootherTipText() {
        return "The smoothing algorithm to use for smoothing the GC points (abundances) of the chromatogram.";
    }

    @Override
    protected void updateDatabaseConnection() {
        if (this.m_Smoother instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_Smoother)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected T processData(T data) {
        AbstractSmoother smoother = this.m_Smoother.shallowCopy(true);
        T result = smoother.smooth(data);
        smoother.destroy();
        return result;
    }
}

