/*
 * Decompiled with CFR 0.152.
 */
package adams.data.fit;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.annotation.MixedCopyright;
import adams.core.option.OptionUtils;
import adams.data.fit.Fit;
import adams.data.fit.InitialParameterGuesser;
import adams.data.fit.LinearFunction;
import adams.data.fit.Polynomial;

@MixedCopyright
public class LinearLeastSquares
extends Fit
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -1573174349202683444L;
    public static final double TOL = 1.0E-5;
    protected LinearFunction m_Function;
    protected int m_NumIterations;

    public String globalInfo() {
        return "Performs linear least squares to fit a function to 2-D data. Uses SVD decomposition.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("function", "function", new Polynomial());
        this.m_OptionManager.add("iterations", "numIterations", 30);
    }

    public String getDescription() {
        return "Linear least squares";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INBOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "William H. Press and Saul A. Teukolsky and William T. Vetterling and Brian P. Flannery");
        result.setValue(TechnicalInformation.Field.SERIES, "Numerical Recipes in C");
        result.setValue(TechnicalInformation.Field.EDITION, "Second");
        result.setValue(TechnicalInformation.Field.TITLE, "General Linear Least Squares");
        result.setValue(TechnicalInformation.Field.CHAPTER, "15.4");
        result.setValue(TechnicalInformation.Field.PAGES, "671-681");
        result.setValue(TechnicalInformation.Field.YEAR, "1992");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Cambridge University Press");
        result.setValue(TechnicalInformation.Field.PDF, "http://www.nrbook.com/a/bookcpdf/c15-4.pdf");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.MISC);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
        additional.setValue(TechnicalInformation.Field.TITLE, "Linear least squares");
        additional.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Linear_least_squares");
        additional = result.add(TechnicalInformation.Type.MISC);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
        additional.setValue(TechnicalInformation.Field.TITLE, "Singular value decomposition");
        additional.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Singular_value_decomposition");
        return result;
    }

    public void setFunction(LinearFunction value) {
        if (value != null) {
            this.m_Function = value;
        } else {
            this.getSystemErr().println("Function cannot be null!");
        }
    }

    public LinearFunction getFunction() {
        return this.m_Function;
    }

    public String functionTipText() {
        return "The function to use for calculating the y values based on the x input.";
    }

    public void setNumIterations(int value) {
        if (value > 0) {
            this.m_NumIterations = value;
        } else {
            this.getSystemErr().println(this.getClass().getName() + ": only positive numbers are allowed for iterations!");
        }
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String numIterationsTipText() {
        return "The number of iterations to perform in singular value decomposition.";
    }

    protected double pythag(double a, double b) {
        double absb;
        double absa = Math.abs(a);
        if (absa > (absb = Math.abs(b))) {
            return absa * Math.sqrt(1.0 + Math.pow(absb / absa, 2.0));
        }
        return absb == 0.0 ? 0.0 : absb * Math.sqrt(1.0 + Math.pow(absa / absb, 2.0));
    }

    protected void svbksb(double[][] u, double[] w, double[][] v, int m, int n, double[] b, double[] x) {
        double s;
        int j;
        double[] tmp = new double[n];
        for (j = 0; j < n; ++j) {
            s = 0.0;
            if (w[j] != 0.0) {
                for (int i = 0; i < m; ++i) {
                    s += u[i][j] * b[i];
                }
                s /= w[j];
            }
            tmp[j] = s;
        }
        for (j = 0; j < n; ++j) {
            s = 0.0;
            for (int jj = 0; jj < n; ++jj) {
                s += v[j][jj] * tmp[jj];
            }
            x[j] = s;
        }
    }

    protected double sign(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    protected boolean svdcmp(double[][] a, int m, int n, double[] w, double[][] v, int iterations) {
        int j;
        double h;
        double f;
        int k;
        double s;
        int i;
        double[] rv1 = new double[n];
        double g = 0.0;
        double scale = 0.0;
        double anorm = 0.0;
        int nm = 0;
        int l = 0;
        for (i = 0; i < n; ++i) {
            l = i + 1;
            rv1[i] = scale * g;
            g = 0.0;
            s = 0.0;
            scale = 0.0;
            if (i < m) {
                for (k = i; k < m; ++k) {
                    scale += Math.abs(a[k][i]);
                }
                if (scale != 1.0) {
                    for (k = i; k < m; ++k) {
                        double[] dArray = a[k];
                        int n2 = i;
                        dArray[n2] = dArray[n2] / scale;
                        s += a[k][i] * a[k][i];
                    }
                    f = a[i][i];
                    g = -this.sign(Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][i] = f - g;
                    for (j = l; j < n; ++j) {
                        s = 0.0;
                        for (k = i; k < m; ++k) {
                            s += a[k][i] * a[k][j];
                        }
                        f = s / h;
                        for (k = i; k < m; ++k) {
                            double[] dArray = a[k];
                            int n3 = j;
                            dArray[n3] = dArray[n3] + f * a[k][i];
                        }
                    }
                    for (k = i; k < m; ++k) {
                        double[] dArray = a[k];
                        int n4 = i;
                        dArray[n4] = dArray[n4] * scale;
                    }
                }
            }
            w[i] = scale * g;
            g = 0.0;
            s = 0.0;
            scale = 0.0;
            if (i < m && i != n - 1) {
                for (k = l; k < n; ++k) {
                    scale += Math.abs(a[i][k]);
                }
                if (scale != 1.0) {
                    for (k = l; k < n; ++k) {
                        double[] dArray = a[i];
                        int n5 = k;
                        dArray[n5] = dArray[n5] / scale;
                        s += a[i][k] * a[i][k];
                    }
                    f = a[i][l];
                    g = -this.sign(Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][l] = f - g;
                    for (k = l; k < n; ++k) {
                        rv1[k] = a[i][k] / h;
                    }
                    for (j = l; j < m; ++j) {
                        s = 0.0;
                        for (k = l; k < n; ++k) {
                            s += a[j][k] * a[i][k];
                        }
                        for (k = l; k < n; ++k) {
                            double[] dArray = a[j];
                            int n6 = k;
                            dArray[n6] = dArray[n6] + s * rv1[k];
                        }
                    }
                    k = l;
                    while (k < n) {
                        double[] dArray = a[i];
                        int n7 = k++;
                        dArray[n7] = dArray[n7] * scale;
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0) {
                    for (j = l; j < n; ++j) {
                        v[j][i] = a[i][j] / a[i][l] / g;
                    }
                    for (j = l; j < n; ++j) {
                        s = 0.0;
                        for (k = l; k < n; ++k) {
                            s += a[i][k] * v[k][j];
                        }
                        for (k = l; k < n; ++k) {
                            double[] dArray = v[k];
                            int n8 = j;
                            dArray[n8] = dArray[n8] + s * v[k][i];
                        }
                    }
                }
                for (j = l; j < n; ++j) {
                    v[i][j] = 0.0;
                    v[j][i] = 0.0;
                }
            }
            v[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = Math.min(m, n) - 1;
        while (i >= 0) {
            l = i + 1;
            g = w[i];
            for (j = l; j < n; ++j) {
                a[i][j] = 0.0;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                for (j = l; j < n; ++j) {
                    s = 0.0;
                    for (k = l; k < m; ++k) {
                        s += a[k][i] * a[k][j];
                    }
                    f = s / a[i][i] * g;
                    for (k = i; k < m; ++k) {
                        double[] dArray = a[k];
                        int n9 = j;
                        dArray[n9] = dArray[n9] + f * a[k][i];
                    }
                }
                for (j = i; j < m; ++j) {
                    double[] dArray = a[j];
                    int n10 = i;
                    dArray[n10] = dArray[n10] * g;
                }
            } else {
                for (j = i; j < m; ++j) {
                    a[j][i] = 0.0;
                }
            }
            double[] dArray = a[i];
            int n11 = i--;
            dArray[n11] = dArray[n11] + 1.0;
        }
        block27: for (k = n - 1; k >= 0; --k) {
            for (int its = 1; its <= iterations; ++its) {
                double z;
                double y;
                double c;
                boolean flag = true;
                for (l = k; l >= 0; --l) {
                    nm = l;
                    if (Math.abs(rv1[l]) < 1.0E-6) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) < 1.0E-6) break;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    for (i = l; i < k; ++i) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) < 1.0E-6) break;
                        g = w[i];
                        w[i] = h = this.pythag(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (j = 0; j < m; ++j) {
                            y = a[j][nm];
                            z = a[j][i];
                            a[j][nm] = y * c + z * s;
                            a[j][i] = z * c - y * s;
                        }
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!(z < 0.0)) continue block27;
                    w[k] = -z;
                    for (j = 0; j < n; ++j) {
                        v[j][k] = -v[j][k];
                    }
                    continue block27;
                }
                if (its == iterations) {
                    this.getSystemErr().println("no convergence in " + its + " svdcmp iterations");
                    return false;
                }
                double x = w[l];
                nm = k;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = this.pythag(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + this.sign(g, f)) - h)) / x;
                c = 1.0;
                s = 1.0;
                for (j = l; j < nm; ++j) {
                    int jj;
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = this.pythag(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 0; jj < n; ++jj) {
                        x = v[jj][j];
                        z = v[jj][i];
                        v[jj][j] = x * c + z * s;
                        v[jj][i] = z * c - x * s;
                    }
                    w[j] = z = this.pythag(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 0; jj < m; ++jj) {
                        y = a[jj][j];
                        z = a[jj][i];
                        a[jj][j] = y * c + z * s;
                        a[jj][i] = z * c - y * s;
                    }
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w[k] = x;
            }
        }
        return true;
    }

    protected boolean svdfit(double[] x, double[] y, double[] sig, int ndata, double[] a, int ma, double[][] u, double[][] v, double[] w, double[] chisq, LinearFunction function, int iterations) {
        int j;
        double tmp;
        int i;
        double[] b = new double[ndata];
        double[] afunc = new double[ma];
        for (i = 0; i < ndata; ++i) {
            afunc = function.calcFunctionValues(x[i], ma);
            tmp = sig != null && sig[i] != 0.0 ? 1.0 / sig[i] : 1.0;
            for (j = 0; j < ma; ++j) {
                u[i][j] = afunc[j] * tmp;
            }
            b[i] = y[i] * tmp;
        }
        boolean result = this.svdcmp(u, ndata, ma, w, v, iterations);
        double wmax = 0.0;
        for (j = 0; j < ma; ++j) {
            if (!(w[j] > wmax)) continue;
            wmax = w[j];
        }
        double thresh = 1.0E-5 * wmax;
        for (j = 0; j < ma; ++j) {
            if (!(w[j] < thresh)) continue;
            w[j] = 0.0;
        }
        this.svbksb(u, w, v, ndata, ma, b, a);
        chisq[0] = 0.0;
        for (i = 0; i < ndata; ++i) {
            afunc = function.calcFunctionValues(x[i], ma);
            double sum = 0.0;
            for (j = 0; j < ma; ++j) {
                sum += a[j] * afunc[j];
            }
            tmp = sig != null && sig[i] != 0.0 ? (y[i] - sum) / sig[i] : y[i] - sum;
            chisq[0] = chisq[0] + tmp * tmp;
        }
        return result;
    }

    public boolean fit(double[] parameters, double[] x, double[] y, double[] sigma_x, double[] sigma_y) {
        double[] a = new double[parameters.length];
        double[] chisq = new double[]{0.0};
        double[][] u = new double[x.length][parameters.length];
        double[][] v = new double[parameters.length][parameters.length];
        double[] w = new double[parameters.length];
        boolean result = this.svdfit(x, y, sigma_y, x.length, a, parameters.length, u, v, w, chisq, this.m_Function, this.m_NumIterations);
        for (int i = 0; i < a.length; ++i) {
            parameters[i] = a[i];
        }
        return result;
    }

    public double calculate(double[] parameters, double x) {
        return this.m_Function.calcY(x, parameters);
    }

    public double[] calculate(double[] parameters, double[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = this.calculate(parameters, x[i]);
        }
        return result;
    }

    public boolean canGuess() {
        return this.m_Function instanceof InitialParameterGuesser;
    }

    public double[] guess(double[] x, double[] y) {
        if (this.canGuess()) {
            return ((InitialParameterGuesser)((Object)this.m_Function)).guess(x, y);
        }
        return null;
    }

    public String toString() {
        return this.getDescription() + ": " + OptionUtils.getCommandLine(this.m_Function);
    }
}

