/*
 * Decompiled with CFR 0.152.
 */
package adams.data.random;

import adams.data.random.AbstractSeededRandomNumberGenerator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaRandomInt
extends AbstractSeededRandomNumberGenerator<Integer> {
    private static final long serialVersionUID = 8754317840175980117L;
    protected int m_MinValue;
    protected int m_MaxValue;
    protected Random m_Random;

    @Override
    public String globalInfo() {
        return "Random generator that generates random integers using Java's java.util.Random class.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-value", "minValue", 1);
        this.m_OptionManager.add("max-value", "maxValue", 1000);
    }

    @Override
    public void reset() {
        super.reset();
        this.m_Random = null;
    }

    public void setMinValue(int value) {
        this.m_MinValue = value;
        this.reset();
    }

    public int getMinValue() {
        return this.m_MinValue;
    }

    public String minValueTipText() {
        return "The smallest number that could be generated.";
    }

    public void setMaxValue(int value) {
        this.m_MaxValue = value;
        this.reset();
    }

    public int getMaxValue() {
        return this.m_MaxValue;
    }

    public String maxValueTipText() {
        return "The largest number that could be generated.";
    }

    @Override
    protected void check() {
        super.check();
        if (this.getMinValue() >= this.getMaxValue()) {
            throw new IllegalStateException("MinValue must be smaller than MaxValue: MinValue=" + this.getMinValue() + ", MaxValue=" + this.getMaxValue());
        }
        if (this.m_Random == null) {
            this.m_Random = new Random(this.m_Seed);
        }
    }

    @Override
    protected Integer doNext() {
        return this.m_Random.nextInt(this.m_MaxValue - this.m_MinValue + 1) + this.m_MinValue;
    }
}

